/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import java.util.HashMap;
import java.util.Map;

public class IdIndex {
    private final Map<Integer, Long> entityIdMap = new HashMap<Integer, Long>();
    private final Map<Long, Integer> idMap = new HashMap<Long, Integer>();
    private int minId;
    private int maxId;
    private int nextId;

    public IdIndex(int minId) {
        this(minId, 65536);
    }

    public IdIndex(int minId, int maxId) {
        this.minId = minId;
        this.maxId = maxId;
        this.nextId = minId;
    }

    protected void incrementNextId() {
        ++this.nextId;
        if (this.nextId > this.maxId) {
            this.nextId = this.minId;
        }
    }

    protected int nextId(Long entity) {
        while (this.entityIdMap.containsKey(this.nextId)) {
            System.out.println("******** ID already in use:" + this.nextId);
            this.incrementNextId();
        }
        int result = this.nextId;
        this.entityIdMap.put(result, entity);
        this.idMap.put(entity, result);
        this.incrementNextId();
        return result;
    }

    public int getId(Long entity, boolean create) {
        Integer result = this.idMap.get(entity);
        if (result == null && create) {
            return this.nextId(entity);
        }
        return result == null ? -1 : result;
    }

    public Long getEntityId(int id) {
        return this.entityIdMap.get(id);
    }

    public void retireId(int id) {
        Long removed = this.entityIdMap.remove(id);
        if (removed == null) {
            System.out.println("**** Retired id:" + id + " with no mapped entity.");
        }
        this.idMap.remove(removed);
    }
}

