/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.Floor;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

class Floor1
extends Floor
implements Cloneable {
    private int[] partitionClassList;
    private int maximumClass;
    private int multiplier;
    private int rangeBits;
    private int[] classDimensions;
    private int[] classSubclasses;
    private int[] classMasterbooks;
    private int[][] subclassBooks;
    private int[] xList;
    private int[] yList;
    private int[] lowNeighbours;
    private int[] highNeighbours;
    private static final int[] RANGES = new int[]{256, 128, 86, 64};

    private Floor1() {
    }

    protected Floor1(BitInputStream source, SetupHeader header) throws VorbisFormatException, IOException {
        int i;
        this.maximumClass = -1;
        int partitions = source.getInt(5);
        this.partitionClassList = new int[partitions];
        for (int i2 = 0; i2 < this.partitionClassList.length; ++i2) {
            this.partitionClassList[i2] = source.getInt(4);
            if (this.partitionClassList[i2] <= this.maximumClass) continue;
            this.maximumClass = this.partitionClassList[i2];
        }
        this.classDimensions = new int[this.maximumClass + 1];
        this.classSubclasses = new int[this.maximumClass + 1];
        this.classMasterbooks = new int[this.maximumClass + 1];
        this.subclassBooks = new int[this.maximumClass + 1][];
        int xListLength = 2;
        for (int i3 = 0; i3 <= this.maximumClass; ++i3) {
            this.classDimensions[i3] = source.getInt(3) + 1;
            xListLength += this.classDimensions[i3];
            this.classSubclasses[i3] = source.getInt(2);
            if (this.classDimensions[i3] > header.getCodeBooks().length || this.classSubclasses[i3] > header.getCodeBooks().length) {
                throw new VorbisFormatException("There is a class dimension or class subclasses entry higher than the number of codebooks in the setup header.");
            }
            if (this.classSubclasses[i3] != 0) {
                this.classMasterbooks[i3] = source.getInt(8);
            }
            this.subclassBooks[i3] = new int[1 << this.classSubclasses[i3]];
            for (int j = 0; j < this.subclassBooks[i3].length; ++j) {
                this.subclassBooks[i3][j] = source.getInt(8) - 1;
            }
        }
        this.multiplier = source.getInt(2) + 1;
        this.rangeBits = source.getInt(4);
        boolean floorValues = false;
        ArrayList<Integer> alXList = new ArrayList<Integer>();
        alXList.add(new Integer(0));
        alXList.add(new Integer(1 << this.rangeBits));
        for (int i4 = 0; i4 < partitions; ++i4) {
            for (int j = 0; j < this.classDimensions[this.partitionClassList[i4]]; ++j) {
                alXList.add(new Integer(source.getInt(this.rangeBits)));
            }
        }
        this.xList = new int[alXList.size()];
        this.lowNeighbours = new int[this.xList.length];
        this.highNeighbours = new int[this.xList.length];
        Iterator iter = alXList.iterator();
        for (i = 0; i < this.xList.length; ++i) {
            this.xList[i] = (Integer)iter.next();
        }
        for (i = 0; i < this.xList.length; ++i) {
            this.lowNeighbours[i] = Util.lowNeighbour(this.xList, i);
            this.highNeighbours[i] = Util.highNeighbour(this.xList, i);
        }
    }

    protected int getType() {
        return 1;
    }

    protected Floor decodeFloor(VorbisStream vorbis, BitInputStream source) throws VorbisFormatException, IOException {
        if (!source.getBit()) {
            return null;
        }
        Floor1 clone = (Floor1)this.clone();
        clone.yList = new int[this.xList.length];
        int range = RANGES[this.multiplier - 1];
        clone.yList[0] = source.getInt(Util.ilog(range - 1));
        clone.yList[1] = source.getInt(Util.ilog(range - 1));
        int offset = 2;
        for (int i = 0; i < this.partitionClassList.length; ++i) {
            int cls = this.partitionClassList[i];
            int cdim = this.classDimensions[cls];
            int cbits = this.classSubclasses[cls];
            int csub = (1 << cbits) - 1;
            int cval = 0;
            if (cbits > 0) {
                cval = source.getInt(vorbis.getSetupHeader().getCodeBooks()[this.classMasterbooks[cls]].getHuffmanRoot());
            }
            for (int j = 0; j < cdim; ++j) {
                int book = this.subclassBooks[cls][cval & csub];
                cval >>>= cbits;
                clone.yList[j + offset] = book >= 0 ? source.getInt(vorbis.getSetupHeader().getCodeBooks()[book].getHuffmanRoot()) : 0;
            }
            offset += cdim;
        }
        return clone;
    }

    protected void computeFloor(float[] vector) {
        int n = vector.length;
        int values = this.xList.length;
        boolean[] step2Flags = new boolean[values];
        int range = RANGES[this.multiplier - 1];
        for (int i = 2; i < values; ++i) {
            int room;
            int lowNeighbourOffset = this.lowNeighbours[i];
            int highNeighbourOffset = this.highNeighbours[i];
            int predicted = Util.renderPoint(this.xList[lowNeighbourOffset], this.xList[highNeighbourOffset], this.yList[lowNeighbourOffset], this.yList[highNeighbourOffset], this.xList[i]);
            int val = this.yList[i];
            int highRoom = range - predicted;
            int lowRoom = predicted;
            int n2 = room = highRoom < lowRoom ? highRoom * 2 : lowRoom * 2;
            if (val != 0) {
                step2Flags[lowNeighbourOffset] = true;
                step2Flags[highNeighbourOffset] = true;
                step2Flags[i] = true;
                if (val >= room) {
                    this.yList[i] = highRoom > lowRoom ? val - lowRoom + predicted : -val + highRoom + predicted - 1;
                    continue;
                }
                this.yList[i] = (val & 1) == 1 ? predicted - (val + 1 >> 1) : predicted + (val >> 1);
                continue;
            }
            step2Flags[i] = false;
            this.yList[i] = predicted;
        }
        int[] xList2 = new int[values];
        System.arraycopy(this.xList, 0, xList2, 0, values);
        Floor1.sort(xList2, this.yList, step2Flags);
        int hx = 0;
        int hy = 0;
        int lx = 0;
        int ly = this.yList[0] * this.multiplier;
        float[] vector2 = new float[vector.length];
        float[] vector3 = new float[vector.length];
        Arrays.fill(vector2, 1.0f);
        System.arraycopy(vector, 0, vector3, 0, vector.length);
        for (int i = 1; i < values; ++i) {
            if (!step2Flags[i]) continue;
            hy = this.yList[i] * this.multiplier;
            hx = xList2[i];
            Util.renderLine(lx, ly, hx, hy, vector);
            Util.renderLine(lx, ly, hx, hy, vector2);
            lx = hx;
            ly = hy;
        }
        float r = DB_STATIC_TABLE[hy];
        while (hx < n / 2) {
            vector[hx++] = r;
        }
    }

    public Object clone() {
        Floor1 clone = new Floor1();
        clone.classDimensions = this.classDimensions;
        clone.classMasterbooks = this.classMasterbooks;
        clone.classSubclasses = this.classSubclasses;
        clone.maximumClass = this.maximumClass;
        clone.multiplier = this.multiplier;
        clone.partitionClassList = this.partitionClassList;
        clone.rangeBits = this.rangeBits;
        clone.subclassBooks = this.subclassBooks;
        clone.xList = this.xList;
        clone.yList = this.yList;
        clone.lowNeighbours = this.lowNeighbours;
        clone.highNeighbours = this.highNeighbours;
        return clone;
    }

    private static final void sort(int[] x, int[] y, boolean[] b) {
        int off = 0;
        int len = x.length;
        int lim = len + off;
        for (int i = off; i < lim; ++i) {
            for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                int itmp = x[j];
                x[j] = x[j - 1];
                x[j - 1] = itmp;
                itmp = y[j];
                y[j] = y[j - 1];
                y[j - 1] = itmp;
                boolean btmp = b[j];
                b[j] = b[j - 1];
                b[j - 1] = btmp;
            }
        }
    }

    private static final void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static final void swap(boolean[] x, int a, int b) {
        boolean t = x[a];
        x[a] = x[b];
        x[b] = t;
    }
}

