/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldView {
    static Logger log = LoggerFactory.getLogger(WorldView.class);
    private World world;
    private GridCell cell;
    private Vec3i origin;
    private LeafId leafId;
    private LeafData leaf;
    private LightData light;
    private FluidData fluid;

    public WorldView(World world) {
        this.world = world;
    }

    protected void validate(Vec3d worldPos) {
        if (this.cell != null && !this.cell.contains(worldPos)) {
            this.cell = null;
        }
        if (this.cell == null) {
            this.cell = LeafId.GRID.getContainingCell(worldPos);
            this.leafId = new LeafId(this.cell.getId());
            this.origin = this.cell.getWorldOrigin();
            this.leaf = null;
            this.light = null;
            this.fluid = null;
        }
    }

    protected LeafData getLeafData(Vec3d worldPos) {
        this.validate(worldPos);
        if (this.leaf == null) {
            this.leaf = this.world.getLeaf(this.leafId);
        }
        return this.leaf;
    }

    protected LightData getLightData(Vec3d worldPos) {
        this.validate(worldPos);
        if (this.light == null) {
            this.light = this.world.getLight(this.leafId);
        }
        return this.light;
    }

    protected FluidData getFluidData(Vec3d worldPos) {
        this.validate(worldPos);
        if (this.fluid == null) {
            this.fluid = this.world.getFluid(this.leafId);
        }
        return this.fluid;
    }

    public int getBlock(Vec3d worldPos) {
        LeafData data = this.getLeafData(worldPos);
        if (data == null) {
            return 0;
        }
        int i = (int)Math.floor(worldPos.x) - this.origin.x;
        int j = (int)Math.floor(worldPos.y) - this.origin.y;
        int k = (int)Math.floor(worldPos.z) - this.origin.z;
        return data.getCell(i, j, k);
    }

    public int getLight(Vec3d worldPos) {
        LightData data = this.getLightData(worldPos);
        if (data == null) {
            return LightUtils.DIRECT_SUN;
        }
        int i = (int)Math.floor(worldPos.x) - this.origin.x;
        int j = (int)Math.floor(worldPos.y) - this.origin.y;
        int k = (int)Math.floor(worldPos.z) - this.origin.z;
        return data.getCell(i, j, k);
    }

    public int getFluid(Vec3d worldPos) {
        FluidData data = this.getFluidData(worldPos);
        if (data == null) {
            return 0;
        }
        int i = (int)Math.floor(worldPos.x) - this.origin.x;
        int j = (int)Math.floor(worldPos.y) - this.origin.y;
        int k = (int)Math.floor(worldPos.z) - this.origin.z;
        return data.getCell(i, j, k);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

