/*
 *  Some commands for looking at runtime stats.
 */

def help = [
    "- shows some system/service diagnostics."
]
updateAdminCommand("diag", help) { shell, args ->
    gameSystems.systems.each { system ->
        if( system.hasProperty('diagnostics') ) {
            shell.echo("" + system.getClass().getSimpleName() + ": " + system.diagnostics)
            log.info("" + system.getClass().getSimpleName() + ": " + system.diagnostics)
        }
        if( system.hasProperty('diagnostics2') ) {
            //shell.echo("" + system.diagnostics2)
            log.info("" + system.diagnostics2)
        }
    }
}


