/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.base;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityCriteria;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.es.base.DefaultEntity;
import com.simsilica.es.base.DefaultEntityData;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntitySet
extends AbstractSet<Entity>
implements EntitySet {
    static Logger log = LoggerFactory.getLogger(DefaultEntitySet.class);
    protected static final RemovedComponent REMOVED_COMPONENT = new RemovedComponent();
    private final Map<EntityId, Entity> entities = new HashMap<EntityId, Entity>();
    private final ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();
    private final EntityData ed;
    private final Class<? extends EntityComponent>[] types;
    private final EntityCriteria criteria;
    private ComponentFilter[] filters;
    private boolean filtersChanged = false;
    protected Transaction transaction = new Transaction();
    private final Set<Entity> addedEntities = new HashSet<Entity>();
    private final Set<Entity> changedEntities = new HashSet<Entity>();
    private final Set<Entity> removedEntities = new HashSet<Entity>();
    private boolean released = false;
    private static final int WATCHDOG_INTERVAL = 1000;
    private int watchdog = 1000;

    @Deprecated
    public DefaultEntitySet(EntityData ed, ComponentFilter filter, Class<? extends EntityComponent>[] types) {
        this(ed, new EntityCriteria().set(filter, types));
    }

    public DefaultEntitySet(EntityData ed, EntityCriteria criteria) {
        this.ed = ed;
        this.criteria = criteria.clone();
        this.types = criteria.toTypeArray();
        this.filters = criteria.toFilterArray();
    }

    protected EntityCriteria getCriteria() {
        return this.criteria;
    }

    protected Class<? extends EntityComponent>[] getTypes() {
        return this.types;
    }

    protected ComponentFilter[] getFilters() {
        return this.filters;
    }

    public String debugId() {
        return "EntitySet@" + System.identityHashCode(this);
    }

    protected void loadEntities(boolean reload) {
        Set<EntityId> idSet = this.ed.findEntities(this.criteria);
        if (idSet.isEmpty()) {
            return;
        }
        EntityComponent[] buffer = new EntityComponent[this.types.length];
        for (EntityId id : idSet) {
            if (reload && this.containsId(id)) continue;
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = this.ed.getComponent(id, this.types[i]);
            }
            DefaultEntity e = new DefaultEntity(this.ed, id, (EntityComponent[])buffer.clone(), this.types);
            if (!this.add(e) || !reload) continue;
            this.addedEntities.add(e);
        }
    }

    protected void purgeEntities() {
        Iterator<Entity> it = this.iterator();
        while (it.hasNext()) {
            Entity e = it.next();
            if (this.entityMatches(e)) continue;
            it.remove();
            this.removedEntities.add(e);
            this.onEntityPurged(e);
        }
    }

    protected void onEntityPurged(Entity e) {
    }

    @Override
    public void resetFilter(ComponentFilter filter) {
        if (filter == null) {
            this.criteria.clearFilters();
        } else {
            this.criteria.setFilter(filter.getComponentType(), filter);
        }
        this.resetEntityCriteria(this.criteria);
    }

    @Override
    public void resetEntityCriteria(EntityCriteria update) {
        if (this.criteria != update) {
            Object[] updateTypes = update.toTypeArray();
            if (!Arrays.equals(this.types, updateTypes)) {
                throw new IllegalArgumentException("Types do not match, existing:" + Arrays.asList(this.types) + ", update:" + Arrays.asList(updateTypes));
            }
            this.criteria.clearFilters();
            for (ComponentFilter filter : update.getFilters()) {
                if (filter == null) continue;
                this.criteria.setFilter(filter.getComponentType(), filter);
            }
        }
        this.filters = this.criteria.toFilterArray();
        this.filtersChanged();
    }

    protected void filtersChanged() {
        this.filtersChanged = true;
    }

    @Override
    public boolean containsId(EntityId id) {
        return this.entities.containsKey(id);
    }

    @Override
    public Set<EntityId> getEntityIds() {
        return this.entities.keySet();
    }

    @Override
    public Entity getEntity(EntityId id) {
        return this.entities.get(id);
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    @Override
    public Iterator<Entity> iterator() {
        return new EntityIterator();
    }

    @Override
    public void clear() {
        this.entities.clear();
    }

    @Override
    public boolean add(Entity e) {
        return this.entities.put(e.getId(), e) == null;
    }

    protected Entity remove(EntityId id) {
        return this.entities.remove(id);
    }

    @Override
    public boolean remove(Object e) {
        if (!(e instanceof Entity)) {
            return false;
        }
        return this.entities.remove(((Entity)e).getId()) != null;
    }

    @Override
    public boolean contains(Object e) {
        if (!(e instanceof Entity)) {
            return false;
        }
        return this.entities.containsKey(((Entity)e).getId());
    }

    @Override
    public Set<Entity> getAddedEntities() {
        return this.addedEntities;
    }

    @Override
    public Set<Entity> getChangedEntities() {
        return this.changedEntities;
    }

    @Override
    public Set<Entity> getRemovedEntities() {
        return this.removedEntities;
    }

    @Override
    public void clearChangeSets() {
        this.addedEntities.clear();
        this.changedEntities.clear();
        this.removedEntities.clear();
    }

    @Override
    public boolean hasChanges() {
        return !this.addedEntities.isEmpty() || !this.changedEntities.isEmpty() || !this.removedEntities.isEmpty();
    }

    @Override
    public boolean applyChanges() {
        return this.applyChanges(null, true);
    }

    @Override
    @Deprecated
    public boolean applyChanges(Set<EntityChange> updates) {
        return this.applyChanges(updates, true);
    }

    protected boolean buildTransactionChanges(Set<EntityChange> updates) {
        EntityChange change;
        if (this.changes.isEmpty()) {
            return false;
        }
        while ((change = this.changes.poll()) != null) {
            this.transaction.addChange(change, updates);
        }
        this.watchdog = 1000;
        return true;
    }

    public boolean hasFilterChanged() {
        return this.filtersChanged;
    }

    protected boolean applyChanges(Set<EntityChange> updates, boolean clearChangeSets) {
        if (clearChangeSets) {
            this.clearChangeSets();
        }
        if (this.released) {
            this.changes.clear();
            this.watchdog = 1000;
            this.removedEntities.addAll(this);
            this.clear();
            return this.hasChanges();
        }
        if (this.buildTransactionChanges(updates)) {
            this.transaction.resolveChanges();
        }
        if (this.filtersChanged) {
            this.filtersChanged = false;
            this.filters = this.criteria.toFilterArray();
            this.purgeEntities();
            this.loadEntities(true);
        }
        return !this.addedEntities.isEmpty() || !this.changedEntities.isEmpty() || !this.removedEntities.isEmpty();
    }

    @Override
    public void release() {
        if (this.ed instanceof DefaultEntityData) {
            ((DefaultEntityData)this.ed).releaseEntitySet(this);
        }
        this.released = true;
    }

    protected boolean isReleased() {
        return this.released;
    }

    protected boolean entityMatches(Entity e) {
        EntityComponent[] array = e.getComponents();
        for (int i = 0; i < this.types.length; ++i) {
            if (array[i] == null) {
                return false;
            }
            if (array[i] == REMOVED_COMPONENT) {
                array[i] = null;
                return false;
            }
            if (this.filters[i] == null || this.filters[i].evaluate(array[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isMatchingComponent(EntityComponent c) {
        return this.criteria.isMatchingComponent(c);
    }

    @Override
    public final boolean hasType(Class type) {
        return this.criteria.hasType(type);
    }

    private int typeIndex(Class type) {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != type) continue;
            return i;
        }
        return -1;
    }

    protected boolean isRelevantChange(EntityChange change) {
        if (!this.hasType(change.getComponentType())) {
            if (log.isTraceEnabled()) {
                log.trace("   not our type.");
            }
            return false;
        }
        return true;
    }

    protected void entityChange(EntityChange change) {
        if (log.isTraceEnabled()) {
            log.trace("entityChange(" + change + ")");
        }
        if (!this.isRelevantChange(change)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Adding change:" + change);
        }
        this.changes.add(change);
        if (this.changes.size() > this.watchdog) {
            log.warn("Entity change count:" + this.changes.size() + " exceeds " + this.watchdog + " events for:" + this);
            this.watchdog += 1000;
        }
    }

    protected boolean completeEntity(DefaultEntity e) {
        EntityComponent[] array = e.getComponents();
        for (int i = 0; i < this.types.length; ++i) {
            ComponentFilter filter;
            boolean rechecking = false;
            if (array[i] == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Pulling component type:" + this.types[i] + " for id:" + e.getId());
                }
                array[i] = this.ed.getComponent(e.getId(), this.types[i]);
                if (array[i] == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Entity " + e.getId() + " could not be completed for type:" + this.types[i]);
                    }
                    return false;
                }
            } else {
                if (array[i] == REMOVED_COMPONENT) {
                    array[i] = null;
                    return false;
                }
                rechecking = true;
            }
            if ((filter = this.filters[i]) == null || filter.evaluate(array[i])) continue;
            return false;
        }
        e.validate();
        return true;
    }

    protected ConcurrentLinkedQueue<EntityChange> getChangeQueue() {
        return this.changes;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("types", Arrays.asList(this.types)).add("criteria", (Object)this.criteria).add("entityCount", this.entities.size()).add("changeCount", this.changes.size()).add("released", this.released).toString();
    }

    protected class Transaction {
        final Map<EntityId, DefaultEntity> adds = new HashMap<EntityId, DefaultEntity>();
        final Set<EntityId> mods = new HashSet<EntityId>();
        final Set<EntityId> purges = new HashSet<EntityId>();

        protected Transaction() {
        }

        public void directAdd(DefaultEntity e) {
            Entity existing = DefaultEntitySet.this.getEntity(e.getId());
            if (existing != null) {
                log.warn("Fully replacing existing entity:" + existing + " with:" + e);
            }
            this.adds.put(e.getId(), e);
            this.purges.remove(e.getId());
        }

        public void directPurge(EntityId id) {
            this.purges.add(id);
            this.adds.remove(id);
        }

        public void addChange(EntityChange change, Set<EntityChange> updates) {
            EntityId id = change.getEntityId();
            EntityComponent comp = change.getComponent();
            DefaultEntity e = (DefaultEntity)DefaultEntitySet.this.entities.get(id);
            if (e == null) {
                e = this.adds.get(id);
                if (e == null) {
                    if (comp == null) {
                        return;
                    }
                    if (!DefaultEntitySet.this.isMatchingComponent(comp)) {
                        return;
                    }
                    e = new DefaultEntity(DefaultEntitySet.this.ed, id, new EntityComponent[DefaultEntitySet.this.types.length], DefaultEntitySet.this.types);
                    this.adds.put(id, e);
                }
            } else {
                this.mods.add(id);
            }
            int index = comp == null ? DefaultEntitySet.this.typeIndex(change.getComponentType()) : DefaultEntitySet.this.typeIndex(comp.getClass());
            if (updates != null && (comp == null || DefaultEntitySet.this.filters[index] == null || DefaultEntitySet.this.filters[index].evaluate(comp))) {
                updates.add(change);
            }
            e.getComponents()[index] = comp != null ? comp : REMOVED_COMPONENT;
        }

        public void resolveChanges() {
            Entity e;
            for (DefaultEntity e2 : this.adds.values()) {
                if (!DefaultEntitySet.this.completeEntity(e2) || !DefaultEntitySet.this.add(e2)) continue;
                DefaultEntitySet.this.addedEntities.add(e2);
            }
            for (EntityId id : this.purges) {
                e = (Entity)DefaultEntitySet.this.entities.get(id);
                if (e != null && DefaultEntitySet.this.remove(e)) {
                    DefaultEntitySet.this.removedEntities.add(e);
                }
                this.mods.remove(id);
            }
            for (EntityId id : this.mods) {
                e = (Entity)DefaultEntitySet.this.entities.get(id);
                if (DefaultEntitySet.this.entityMatches(e)) {
                    DefaultEntitySet.this.changedEntities.add(e);
                    continue;
                }
                if (!DefaultEntitySet.this.remove(e)) continue;
                DefaultEntitySet.this.removedEntities.add(e);
            }
            this.adds.clear();
            this.mods.clear();
            this.purges.clear();
        }
    }

    protected static class RemovedComponent
    implements EntityComponent {
        protected RemovedComponent() {
        }
    }

    private class EntityIterator
    implements Iterator<Entity> {
        private final Iterator<Map.Entry<EntityId, Entity>> delegate;

        public EntityIterator() {
            this.delegate = DefaultEntitySet.this.entities.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Entity next() {
            return this.delegate.next().getValue();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

