/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.AbstractControlDriver;
import com.simsilica.mphys.RigidBody;
import mythruna.es.VehicleInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleDriver
extends AbstractControlDriver<EntityId, MBlockShape> {
    static Logger log = LoggerFactory.getLogger(VehicleDriver.class);
    private EntityData ed;
    private EntityId vehicle;
    private double[] angles = new double[3];

    public VehicleDriver(EntityData ed, EntityId vehicle) {
        this.ed = ed;
        this.vehicle = vehicle;
    }

    public void initialize(RigidBody<EntityId, MBlockShape> body) {
        super.initialize(body);
        body.setLinearAcceleration(new Vec3d(0.0, 0.0, 0.0));
    }

    public void applyVehicleInput(VehicleInput input) {
        if (log.isTraceEnabled()) {
            log.trace("applyInput(" + input + ")");
        }
    }

    protected void killVerticalRotation(RigidBody<EntityId, MBlockShape> body) {
        body.orientation.toAngles(this.angles);
        if (this.angles[0] != 0.0 || this.angles[2] != 0.0) {
            this.angles[0] = 0.0;
            this.angles[2] = 0.0;
            body.orientation.fromAngles(this.angles);
        }
        Vec3d rot = body.getRotationalVelocity();
        if (rot.x != 0.0 || rot.z != 0.0) {
            rot.x = 0.0;
            rot.z = 0.0;
            body.setRotationalVelocity(rot);
        }
    }

    public void update(long frameTime, double step) {
        this.killVerticalRotation((RigidBody<EntityId, MBlockShape>)this.getBody());
        Vec3d dir = this.getBody().orientation.mult(new Vec3d(1.0, 0.0, 0.0));
        this.getBody().setLinearVelocity(dir);
    }
}

