/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.ColumnChangeListener;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.Coordinates;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.tree.TreeLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalWorld
implements World {
    static Logger log = LoggerFactory.getLogger(PhysicalWorld.class);
    private ColumnDb colDb;
    private int yMax;

    public PhysicalWorld(ColumnDb colDb, int yMax) {
        this.colDb = colDb;
        this.yMax = yMax;
    }

    public int getMaxY() {
        return this.yMax;
    }

    public int setWorldCell(Vec3d world, int cellType) {
        throw new UnsupportedOperationException();
    }

    public int getWorldCell(Vec3d world) {
        ColumnId colId = ColumnId.fromWorld((Vec3d)world);
        ColumnData col = this.colDb.getColumn(colId);
        LeafData leaf = col.getLeafData((int)world.y);
        if (leaf == null) {
            return -1;
        }
        int x = Coordinates.worldToCell((double)world.x) - leaf.getInfo().location.x;
        int y = Coordinates.worldToCell((double)world.y) - leaf.getInfo().location.y;
        int z = Coordinates.worldToCell((double)world.z) - leaf.getInfo().location.z;
        return leaf.getCell(x, y, z);
    }

    public LeafData getWorldLeaf(Vec3d worldLocation) {
        return this.getLeaf(LeafId.fromWorld((Vec3d)worldLocation));
    }

    public LeafData getLeaf(LeafId leafId) {
        ColumnId colId = leafId.getColumnId();
        ColumnData col = this.colDb.getColumn(colId);
        Vec3i world = leafId.getWorld(null);
        return col.getLeafData(world.y);
    }

    public FluidData getFluid(LeafId leafId) {
        ColumnId colId = leafId.getColumnId();
        ColumnData col = this.colDb.getColumn(colId);
        Vec3i world = leafId.getWorld(null);
        return col.getFluidData(world.y);
    }

    public LightData getLight(LeafId leafId) {
        throw new UnsupportedOperationException();
    }

    public TerrainImage getTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        throw new UnsupportedOperationException();
    }

    public TreeLayer getTrees(TileId id, Resolution res) {
        throw new UnsupportedOperationException();
    }

    public PointCloudLayer getPointCloudLayer(TileId id, Resolution res) {
        throw new UnsupportedOperationException();
    }

    public void addTileListener(TileListener l) {
        throw new UnsupportedOperationException();
    }

    public void removeTileListener(TileListener l) {
        throw new UnsupportedOperationException();
    }

    public void addLeafChangeListener(LeafChangeListener l) {
        throw new UnsupportedOperationException();
    }

    public void removeLeafChangeListener(LeafChangeListener l) {
        throw new UnsupportedOperationException();
    }

    public void addCellChangeListener(CellChangeListener l) {
        throw new UnsupportedOperationException();
    }

    public void removeCellChangeListener(CellChangeListener l) {
        throw new UnsupportedOperationException();
    }

    public void addColumnChangeListener(ColumnChangeListener l) {
        throw new UnsupportedOperationException();
    }

    public void removeColumnChangeListener(ColumnChangeListener l) {
        throw new UnsupportedOperationException();
    }
}

