/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.io.ObjectProtocol;
import java.io.IOException;
import mythruna.world.cave.LineInfluencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineInfluencerProtocol
implements ObjectProtocol<LineInfluencer> {
    static Logger log = LoggerFactory.getLogger(LineInfluencerProtocol.class);
    public static final int X_BITS = 32;
    public static final int Y_BITS = 10;
    public static final int Z_BITS = 32;
    public static final int RADIUS_BITS = 7;
    public static final int TYPE_BITS = 4;
    public static final int FLUID_LEVEL_BITS = 10;
    public static final int FLUID_TYPE_BITS = 8;
    private int version = 0;

    public int getProtocolVersion() {
        return this.version;
    }

    public void write(LineInfluencer data, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 8);
        Vec3i start = data.getStart();
        Vec3i end = data.getEnd();
        out.writeBits(start.x, 32);
        out.writeBits(start.y, 10);
        out.writeBits(start.z, 32);
        out.writeBits(end.x, 32);
        out.writeBits(end.y, 10);
        out.writeBits(end.z, 32);
        out.writeBits(data.getInnerRadius(), 7);
        out.writeBits(data.getOuterRadius(), 7);
        out.writeBits((int)data.getType(), 4);
        out.writeBits(data.getFluidLevel(), 10);
        out.writeBits((int)data.getFluidType(), 8);
    }

    public LineInfluencer read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        int x = in.readBits(32);
        int y = in.readBits(10);
        int z = in.readBits(32);
        Vec3i start = new Vec3i(x, y, z);
        x = in.readBits(32);
        y = in.readBits(10);
        z = in.readBits(32);
        Vec3i end = new Vec3i(x, y, z);
        int inner = in.readBits(7);
        int outer = in.readBits(7);
        byte type = (byte)in.readBits(4);
        int fluidLevel = in.readBits(10);
        byte fluidType = (byte)in.readBits(8);
        return new LineInfluencer(start, end, inner, outer, type, fluidLevel, fluidType);
    }
}

