
uniform sampler2D m_Texture;
varying vec4 texCoord;

varying vec4 color;

#ifdef USE_EMISSIVE
    uniform sampler2D m_EmissiveTexture;
#endif

void main(){
    vec2 uv = mix(texCoord.xy, texCoord.zw, gl_PointCoord.xy);
    vec4 outColor = texture2D(m_Texture, uv) * color;

    #ifdef USE_EMISSIVE
        vec4 emission = texture2D(m_EmissiveTexture, uv);
        outColor.rgb = mix(outColor.rgb, emission.rgb, emission.a);
    #endif
    
    if( outColor.a <= 0.01 ) {
        discard;
    }        
    gl_FragColor = outColor;
    //gl_FragColor = color;
}
