/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugin.export.material;

import com.jme3.export.JmeExporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.plugin.export.material.J3MRootOutputCapsule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class J3MExporter
implements JmeExporter {
    private final J3MRootOutputCapsule rootCapsule = new J3MRootOutputCapsule(this);

    public void save(Savable object, OutputStream f) throws IOException {
        if (!(object instanceof Material)) {
            throw new IllegalArgumentException("J3MExporter can only save com.jme3.material.Material class");
        }
        OutputStreamWriter out = new OutputStreamWriter(f, Charset.forName("UTF-8"));
        this.rootCapsule.clear();
        object.write((JmeExporter)this);
        this.rootCapsule.writeToStream(out);
        out.flush();
    }

    public void save(Savable object, File f) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            this.save(object, fos);
        }
    }

    public OutputCapsule getCapsule(Savable object) {
        if (object instanceof Material || object instanceof MaterialDef) {
            return this.rootCapsule;
        }
        return this.rootCapsule.getCapsule(object);
    }
}

