/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LeafInfo;
import com.simsilica.mworld.io.CellArrayProtocol;
import com.simsilica.mworld.io.ObjectProtocol;
import java.io.IOException;

public class LeafDataProtocol
implements ObjectProtocol<LeafData> {
    private int protocolVersion = 1;
    private CellArrayProtocol cellProtocol = new CellArrayProtocol();

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void write(LeafData leafData, BitOutputStream out) throws IOException {
        out.writeBits(this.protocolVersion, 8);
        out.writeLongBits(leafData.getInfo().leafId.getId(), 64);
        out.writeLongBits(leafData.getInfo().version.getVersion(), 64);
        out.writeBits(leafData.getEmptyCellCount(), 16);
        int[] array = leafData.getArray();
        if (array == null) {
            out.writeBits(0, 1);
            return;
        }
        out.writeBits(1, 1);
        this.cellProtocol.writeRleData(array, 65535, 0, 16, out);
        this.cellProtocol.writeRleData(array, -65536, 16, 16, out);
    }

    @Override
    public LeafData read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        LeafId leafId = new LeafId(in.readLongBits(64));
        Vec3i world = leafId.getWorld(null);
        long dataVersion = in.readLongBits(64);
        LeafInfo info = new LeafInfo(world, leafId, new DataVersion(dataVersion));
        int emptyCellCount = in.readBits(16);
        int nullBit = in.readBits(1);
        if (nullBit == 0) {
            return new LeafData(info, null, emptyCellCount);
        }
        CellArray cells = new CellArray(32);
        this.cellProtocol.readRleData(cells.getArray(), 65535, 0, 16, in);
        this.cellProtocol.readRleData(cells.getArray(), -65536, 16, 16, in);
        return new LeafData(info, cells, emptyCellCount);
    }
}

