/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mblock.io.BlockTypeData;
import com.simsilica.mblock.io.FluidTypeData;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.io.BlockTypeDataProtocol;
import com.simsilica.mworld.io.CellChangeEventProtocol;
import com.simsilica.mworld.io.FluidDataProtocol;
import com.simsilica.mworld.io.FluidTypeDataProtocol;
import com.simsilica.mworld.io.LeafDataProtocol;
import com.simsilica.mworld.io.LightDataProtocol;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.io.TreeTypeIndexProtocol;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.io.TerrainImageProtocol;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.pc.PointCloudLayerProtocol;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.tile.tree.TreeLayerProtocol;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolSerializers {
    static Logger log = LoggerFactory.getLogger(ProtocolSerializers.class);
    private Map<Class, ObjectProtocol> protocols = new HashMap<Class, ObjectProtocol>();

    public ProtocolSerializers() {
        this(true);
    }

    public ProtocolSerializers(boolean registerDefaults) {
        if (registerDefaults) {
            this.registerProtocol(LeafData.class, new LeafDataProtocol());
            this.registerProtocol(LightData.class, new LightDataProtocol());
            this.registerProtocol(FluidData.class, new FluidDataProtocol());
            this.registerProtocol(PointCloudLayer.class, new PointCloudLayerProtocol());
            this.registerProtocol(TerrainImage.class, new TerrainImageProtocol());
            this.registerProtocol(TreeLayer.class, new TreeLayerProtocol());
            this.registerProtocol(CellChangeEvent.class, new CellChangeEventProtocol());
            this.registerProtocol(BlockTypeData.class, new BlockTypeDataProtocol());
            this.registerProtocol(FluidTypeData.class, new FluidTypeDataProtocol());
            this.registerProtocol(TreeTypeIndex.class, new TreeTypeIndexProtocol());
        }
    }

    public <T> void registerProtocol(Class<T> type, ObjectProtocol<T> protocol) {
        this.protocols.put(type, protocol);
    }

    public <T> ObjectProtocol<T> getProtocol(Class<T> type) {
        return this.protocols.get(type);
    }

    public void write(Object data, BitOutputStream out) throws IOException {
        ObjectProtocol protocol = this.protocols.get(data.getClass());
        if (protocol == null) {
            throw new IllegalArgumentException("No ObjectProtocol found for type:" + data.getClass());
        }
        protocol.write(data, out);
    }

    public <T> T read(Class<T> type, BitInputStream in) throws IOException {
        ObjectProtocol protocol = this.protocols.get(type);
        if (protocol == null) {
            throw new IllegalArgumentException("No ObjectProtocol found for type:" + type);
        }
        return type.cast(protocol.read(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Object data, boolean zipped) throws IOException {
        ObjectProtocol protocol = this.protocols.get(data.getClass());
        if (protocol == null) {
            throw new IllegalArgumentException("No ObjectProtocol found for type:" + data.getClass());
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (BitOutputStream out = zipped ? new BitOutputStream((OutputStream)new BufferedOutputStream(new GZIPOutputStream(bOut))) : new BitOutputStream((OutputStream)new BufferedOutputStream(bOut));){
            protocol.write(data, out);
        }
        return bOut.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromBytes(Class<T> type, byte[] bytes, boolean zipped) throws IOException {
        ObjectProtocol protocol = this.protocols.get(type);
        if (protocol == null) {
            throw new IllegalArgumentException("No ObjectProtocol found for type:" + type);
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        try (BitInputStream in = zipped ? new BitInputStream((InputStream)new BufferedInputStream(new GZIPInputStream(bIn))) : new BitInputStream((InputStream)bIn);){
            T t = type.cast(protocol.read(in));
            return t;
        }
    }

    public List<byte[]> toPackets(Object data, int packetSize, boolean zipped) {
        try {
            byte[] buffer = this.toBytes(data, zipped);
            if (buffer.length < packetSize) {
                return Arrays.asList(new byte[][]{buffer});
            }
            int count = buffer.length / packetSize;
            if (buffer.length % packetSize != 0) {
                ++count;
            }
            ArrayList<byte[]> results = new ArrayList<byte[]>(count);
            int bytesRemaining = buffer.length;
            for (int i = 0; i < count; ++i) {
                int size = Math.min(packetSize, bytesRemaining);
                byte[] packet = new byte[size];
                System.arraycopy(buffer, i * packetSize, packet, 0, size);
                results.add(packet);
                bytesRemaining -= size;
            }
            assert (bytesRemaining == 0) : "Mismatched bytes remaining";
            return results;
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting to packets:" + data, e);
        }
    }

    public <T> T fromPackets(Class<T> type, List<byte[]> packets, boolean zipped) {
        try {
            int size = 0;
            for (byte[] packet : packets) {
                size += packet.length;
            }
            byte[] buffer = new byte[size];
            int pos = 0;
            for (byte[] packet : packets) {
                System.arraycopy(packet, 0, buffer, pos, packet.length);
                pos += packet.length;
            }
            return this.fromBytes(type, buffer, zipped);
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting from packets, type:" + type, e);
        }
    }
}

