/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.flac.FlacFormatException;
import de.jarnbjo.flac.MetadataBlock;
import de.jarnbjo.util.io.BitInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class VorbisComment
extends MetadataBlock {
    public static final String TITLE = "TITLE";
    public static final String ARTIST = "ARTIST";
    public static final String ALBUM = "ALBUM";
    public static final String TRACKNUMBER = "TRACKNUMBER";
    public static final String VERSION = "VERSION";
    public static final String PERFORMER = "PERFORMER";
    public static final String COPYRIGHT = "COPYRIGHT";
    public static final String LICENSE = "LICENSE";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String GENRE = "GENRE";
    public static final String DATE = "DATE";
    public static final String LOCATION = "LOCATION";
    public static final String CONTACT = "CONTACT";
    public static final String ISRC = "ISRC";
    private String vendor;
    private HashMap comments = new HashMap();

    public VorbisComment(BitInputStream source) throws FlacFormatException, IOException {
        int length = source.getInt(24);
        source.setEndian(0);
        this.vendor = this.getString(source);
        System.out.println("VENDOR = " + this.vendor);
        int ucLength = source.getInt(32);
        for (int i = 0; i < ucLength; ++i) {
            String comment = this.getString(source);
            int ix = comment.indexOf(61);
            String key = comment.substring(0, ix);
            String value = comment.substring(ix + 1);
            this.addComment(key, value);
        }
    }

    private void addComment(String key, String value) {
        System.out.println(key + " = " + value);
        ArrayList<String> al = (ArrayList<String>)this.comments.get(key);
        if (al == null) {
            al = new ArrayList<String>();
            this.comments.put(key, al);
        }
        al.add(value);
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getComment(String key) {
        ArrayList al = (ArrayList)this.comments.get(key);
        return al == null ? (String)null : (String)al.get(0);
    }

    public String[] getComments(String key) {
        ArrayList al = (ArrayList)this.comments.get(key);
        return al == null ? new String[]{} : al.toArray(new String[al.size()]);
    }

    public String getTitle() {
        return this.getComment(TITLE);
    }

    public String[] getTitles() {
        return this.getComments(TITLE);
    }

    public String getVersion() {
        return this.getComment(VERSION);
    }

    public String[] getVersions() {
        return this.getComments(VERSION);
    }

    public String getAlbum() {
        return this.getComment(ALBUM);
    }

    public String[] getAlbums() {
        return this.getComments(ALBUM);
    }

    public String getTrackNumber() {
        return this.getComment(TRACKNUMBER);
    }

    public String[] getTrackNumbers() {
        return this.getComments(TRACKNUMBER);
    }

    public String getArtist() {
        return this.getComment(ARTIST);
    }

    public String[] getArtists() {
        return this.getComments(ARTIST);
    }

    public String getPerformer() {
        return this.getComment(PERFORMER);
    }

    public String[] getPerformers() {
        return this.getComments(PERFORMER);
    }

    public String getCopyright() {
        return this.getComment(COPYRIGHT);
    }

    public String[] getCopyrights() {
        return this.getComments(COPYRIGHT);
    }

    public String getLicense() {
        return this.getComment(LICENSE);
    }

    public String[] getLicenses() {
        return this.getComments(LICENSE);
    }

    public String getOrganization() {
        return this.getComment(ORGANIZATION);
    }

    public String[] getOrganizations() {
        return this.getComments(ORGANIZATION);
    }

    public String getDescription() {
        return this.getComment(DESCRIPTION);
    }

    public String[] getDescriptions() {
        return this.getComments(DESCRIPTION);
    }

    public String getGenre() {
        return this.getComment(GENRE);
    }

    public String[] getGenres() {
        return this.getComments(GENRE);
    }

    public String getDate() {
        return this.getComment(DATE);
    }

    public String[] getDates() {
        return this.getComments(DATE);
    }

    public String getLocation() {
        return this.getComment(LOCATION);
    }

    public String[] getLocations() {
        return this.getComments(LOCATION);
    }

    public String getContact() {
        return this.getComment(CONTACT);
    }

    public String[] getContacts() {
        return this.getComments(CONTACT);
    }

    public String getIsrc() {
        return this.getComment(ISRC);
    }

    public String[] getIsrcs() {
        return this.getComments(ISRC);
    }

    private String getString(BitInputStream source) throws IOException {
        int length = source.getInt(32);
        System.out.println("length: " + length);
        byte[] strArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            strArray[i] = (byte)source.getInt(8);
        }
        return new String(strArray, "UTF-8");
    }
}

