/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.simsilica.mworld.SedectileId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mythruna.world.tile.LocalRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldRegion {
    static Logger log = LoggerFactory.getLogger(WorldRegion.class);
    private long regionId;
    private long knownArea;
    private List<SedectileId> sedectiles = new ArrayList<SedectileId>();
    private Set<LocalRegion> children = new HashSet<LocalRegion>();

    public WorldRegion(long regionId) {
        this.regionId = regionId;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public long getId() {
        return this.regionId;
    }

    public void addChildRegion(LocalRegion region) {
        if (!this.children.add(region)) {
            log.warn("Child already added, child:" + region + " worldRegionId:" + this.regionId);
            return;
        }
        this.sedectiles.add(region.getSedectileId());
        region.setWorldRegionId(this.regionId);
        this.knownArea += (long)region.getArea();
    }

    public void removeChildRegion(LocalRegion region) {
        if (!this.children.remove(region)) {
            log.warn("Child does not exist in world region, child:" + region + " worldRegionId:" + this.regionId);
            return;
        }
        region.setWorldRegionId(-1L);
        this.knownArea -= (long)region.getArea();
    }

    public long getKnownArea() {
        return this.knownArea;
    }

    public List<SedectileId> getSedectiles() {
        return this.sedectiles;
    }
}

