/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.text.DocumentModel;
import com.simsilica.lemur.text.DocumentModelFilter;
import com.simsilica.lemur.text.TextFilters;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import com.simsilica.progress.view.TrackerView;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.ArrayList;
import java.util.Random;
import mythruna.GameConstants;
import mythruna.client.GuiState;
import mythruna.client.MythrunaConfig;
import mythruna.client.ProgressState;
import mythruna.client.WorldListState;
import mythruna.client.ui.MapPreview;
import mythruna.world.WorldFractalFactory;
import mythruna.world.WorldInfo;
import mythruna.world.WorldLibrary;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateWorldState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CreateWorldState.class);
    private Container window;
    private TextField nameField;
    private Selector<String> fractalField;
    private TextField seedField;
    private Label preview;
    private MapPreview mapPreview;
    private TrackerView trackerView;

    public CreateWorldState() {
        this.setEnabled(false);
    }

    protected void generate() {
        String name = this.getName();
        if (name == null) {
            return;
        }
        Long seed = this.getSeed();
        if (seed == null) {
            return;
        }
        String fractal = this.getFractal();
        if (fractal == null) {
            return;
        }
        WorldLibrary library = ((WorldListState)this.getState(WorldListState.class, true)).getWorldLibrary();
        final WorldInfo info = library.createWorldInfo(name, fractal, seed.longValue());
        final ProgressState progress = (ProgressState)this.getState(ProgressState.class);
        progress.openView((Object)this, "Creating world...");
        MythrunaConfig config = MythrunaConfig.getInstance();
        int poolSize = config.getStartupSettingInt("CreatePreloader.poolSize", 4);
        final ProgressTracker tracker = ProgressTrackers.openTracker((String)"Discovering world...");
        int radius = 1;
        int size = radius * 2 + 1;
        int total = size * size;
        tracker.setMax((double)total);
        final ProgressTrackers.ThreadTrackers parentTrackers = ProgressTrackers.getThreadTrackers(null);
        ((JobState)this.getState(JobState.class)).execute(new Job(){
            private WorldManager world;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runOnWorker() {
                ProgressTrackers.inheritThreadTrackers((ProgressTrackers.ThreadTrackers)parentTrackers);
                try {
                    long start = System.nanoTime();
                    this.world = WorldManager.createWorld((WorldInfo)info);
                    log.info("info spawn point:" + info.getSpawnPoint());
                    SedectileId center = SedectileId.fromWorld((Vec3d)info.getSpawnPoint());
                    log.info("center:" + center);
                    Vec3i origin = center.getWorld(null);
                    int viewRadius = 9216;
                    Vec3i min = origin.subtract(viewRadius, 0, viewRadius);
                    Vec3i max = origin.add(viewRadius, 0, viewRadius);
                    min = SedectileId.fromWorld((Vec3i)min).getWorld(null);
                    max = SedectileId.fromWorld((Vec3i)max).getWorld(null);
                    ArrayList<SedectileId> toLoad = new ArrayList<SedectileId>();
                    toLoad.add(SedectileId.fromWorld((Vec3i)origin));
                    for (int x = min.x; x <= max.x; x += 16384) {
                        for (int z = min.z; z <= max.z; z += 16384) {
                            Vec3i local = origin.add(x, 0, z);
                            toLoad.add(SedectileId.fromWorld((Vec3i)local));
                        }
                    }
                    for (SedectileId id : toLoad) {
                        this.world.getSedectileManager().getSedectile(id, true);
                        tracker.increment();
                    }
                    tracker.close(true);
                    long end = System.nanoTime();
                    log.info(String.format("Created world in %.02f ms", (double)(end - start) / 1000000.0));
                }
                finally {
                    ProgressTrackers.inheritThreadTrackers(null);
                }
            }

            public double runOnUpdate() {
                ((WorldListState)CreateWorldState.this.getState(WorldListState.class)).startWorld(this.world);
                CreateWorldState.this.setEnabled(false);
                progress.releaseView((Object)CreateWorldState.this);
                return 1.0;
            }
        });
    }

    public void cancel() {
        this.setEnabled(false);
    }

    protected void random() {
        Random rand = new Random();
        long l = rand.nextLong();
        this.seedField.setText(String.valueOf(l));
        this.mapPreview.setMap("Preview", null);
    }

    protected void preview() {
        final Long seed = this.getSeed();
        if (seed == null) {
            return;
        }
        float scale = ((GuiState)this.getState(GuiState.class)).getStandardScale() * this.window.getLocalScale().x;
        this.mapPreview.setLabel(null);
        this.mapPreview.getOverlayRoot().attachChild((Spatial)this.trackerView);
        ((JobState)this.getState(JobState.class)).execute(new Job(){
            private QuadBackgroundComponent map;

            public void runOnWorker() {
                this.map = WorldListState.createPreview(CreateWorldState.this.getFractal(), seed, GameConstants.MAP_PREVIEW_SIZE, GameConstants.MAP_PREVIEW_RANGE);
            }

            public double runOnUpdate() {
                CreateWorldState.this.mapPreview.setMap(null, (GuiComponent)this.map);
                CreateWorldState.this.trackerView.removeFromParent();
                return 1.0;
            }
        });
    }

    protected String getName() {
        String s = this.nameField.getText();
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        return s;
    }

    protected Long parseNumber(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            log.info("Not a number", (Throwable)e);
            return null;
        }
    }

    protected Long parseHex(String value) {
        try {
            return Long.parseLong(value, 16);
        }
        catch (NumberFormatException e) {
            log.info("Not a number", (Throwable)e);
            return null;
        }
    }

    protected Long getSeed() {
        String s = this.seedField.getText();
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        Long result = this.parseNumber(s);
        if (result != null) {
            return result;
        }
        result = this.parseHex(s);
        if (result != null) {
            return result;
        }
        return s.hashCode();
    }

    protected String getFractal() {
        String s = (String)this.fractalField.getSelectedItem();
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        return s;
    }

    protected void initialize(Application app) {
        this.window = new Container(new ElementId("window"));
        this.window.addChild((Node)new Label("Create New World", new ElementId("window.title")), new Object[0]);
        Container properties = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        Function nameFilter = TextFilters.charFilter((Predicate)Predicates.or((Predicate)TextFilters.isLetterOrDigit(), (Predicate)TextFilters.isInChars((char[])new char[]{'_', '-', '.', ' '})));
        DocumentModelFilter nameModel = new DocumentModelFilter(nameFilter, null);
        properties.addChild((Node)new Label("Name:"), new Object[0]);
        this.nameField = (TextField)properties.addChild((Node)new TextField((DocumentModel)nameModel), new Object[]{1});
        this.nameField.setInsets(new Insets3f(2.0f, 2.0f, 2.0f, 2.0f));
        VersionedList fractalTypes = new VersionedList(WorldFractalFactory.getFractalTypes());
        properties.addChild((Node)new Label("Fractal:"), new Object[0]);
        this.fractalField = (Selector)properties.addChild((Node)new Selector(fractalTypes), new Object[]{1});
        properties.addChild((Node)new Label("Seed:"), new Object[0]);
        DocumentModelFilter numeric = new DocumentModelFilter(nameFilter, null);
        this.seedField = (TextField)properties.addChild((Node)new TextField((DocumentModel)numeric), new Object[]{1});
        this.seedField.setInsets(new Insets3f(2.0f, 2.0f, 2.0f, 2.0f));
        Container seedPanel = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Even, FillMode.Even)), new Object[0]);
        seedPanel.setBackground(null);
        seedPanel.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "random")), new Object[0]);
        seedPanel.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "preview")), new Object[0]);
        this.trackerView = new TrackerView();
        this.trackerView.setExpandOnly(false);
        this.trackerView.move(0.0f, -160.0f, 0.0f);
        Vector3f pref = this.trackerView.getPreferredSize();
        pref.x = Math.max(pref.x, 384.0f);
        pref.y = 100.0f;
        this.trackerView.setPreferredSize(pref);
        Texture paper = app.getAssetManager().loadTexture("Interface/paper.jpg");
        QuadBackgroundComponent qbc = new QuadBackgroundComponent(paper);
        qbc.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.5f));
        this.trackerView.setBackground((GuiComponent)qbc);
        this.mapPreview = (MapPreview)this.window.addChild((Node)new MapPreview(app.getAssetManager()), new Object[0]);
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "generate")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.75f));
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }
}

