/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.anim.AnimationState;
import com.simsilica.lemur.anim.SpatialTweens;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.Tweens;
import java.util.function.Consumer;
import mythruna.client.sound.SoundState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenShotEffectState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ScreenShotEffectState.class);
    private CaptureListener listener = new CaptureListener();

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((ScreenshotAppState)this.getState(ScreenshotAppState.class, true)).addCaptureListener((Consumer)this.listener);
    }

    protected void onDisable() {
        if (this.getState(ScreenshotAppState.class, false) != null) {
            ((ScreenshotAppState)this.getState(ScreenshotAppState.class)).removeCaptureListener((Consumer)this.listener);
        }
    }

    protected void showSnap(ScreenshotAppState.CaptureInfo info) {
        Camera cam = this.getApplication().getCamera();
        int w = cam.getWidth();
        int h = cam.getHeight();
        GuiGlobals globals = GuiGlobals.getInstance();
        Node snap = new Node("snap");
        Image img = new Image(Image.Format.RGBA8, w, h, info.getOutputBuffer(), ColorSpace.Linear);
        Texture2D texture = new Texture2D(img);
        final ColorRGBA color = ColorRGBA.White.clone();
        Material material = new Material(this.getApplication().getAssetManager(), "MatDefs/Mix.j3md");
        material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        material.setColor("Color", color);
        material.setTexture("MixMap", globals.loadTexture("Interface/faded-border.png", false, false));
        material.setTexture("ColorMap1", globals.loadTexture("Interface/old-paper-flattened.png", false, false));
        material.setTexture("ColorMap2", (Texture)texture);
        Quad mesh = new Quad((float)w, (float)h);
        Geometry geom = new Geometry("snapshot", (Mesh)mesh);
        geom.setMaterial(material);
        snap.attachChild((Spatial)geom);
        globals.getPopupState().showPopup((Spatial)snap);
        double animLength = 1.0;
        double offset = (double)w * 0.1 + Math.random() * (double)w * 0.5;
        Vector3f start = snap.getLocalTranslation();
        Tween move = SpatialTweens.move((Spatial)snap, (Vector3f)start, (Vector3f)start.add((float)offset, (float)(-h), 10.0f), (double)1.0);
        Tween scale = SpatialTweens.scale((Spatial)snap, (float)1.0f, (float)1.5f, (double)1.0);
        Tween fade = new Tween(){

            public double getLength() {
                return 1.0;
            }

            public boolean interpolate(double t) {
                if (t >= this.getLength()) {
                    return false;
                }
                color.a = (float)(1.0 - t / 1.0);
                return true;
            }
        };
        Tween detach = SpatialTweens.detach((Spatial)snap);
        Tween wipe = Tweens.smoothStep((Tween[])new Tween[]{Tweens.parallel((Tween[])new Tween[]{move, fade, scale})});
        ((AnimationState)this.getState(AnimationState.class)).add(new Tween[]{wipe, detach});
    }

    private class CaptureListener
    implements Consumer<ScreenshotAppState.CaptureInfo> {
        private CaptureListener() {
        }

        @Override
        public void accept(ScreenshotAppState.CaptureInfo info) {
            log.info("Screen shot:" + info);
            ((SoundState)ScreenShotEffectState.this.getState(SoundState.class)).playEffect("Quick Save");
            ScreenShotEffectState.this.showSnap(info);
        }
    }
}

