/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.io;

import com.simsilica.io.BytePacketInputStream;
import com.simsilica.io.BytePacketOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationUtils {
    static Logger log = LoggerFactory.getLogger(SerializationUtils.class);

    public static byte[][] objectToPackets(Object o, int maxPacketSize, boolean zipped) {
        try {
            BytePacketOutputStream packetsIn;
            OutputStream out = packetsIn = new BytePacketOutputStream(maxPacketSize);
            if (zipped) {
                out = new GZIPOutputStream(out);
            }
            try (ObjectOutputStream objOut = new ObjectOutputStream(out);){
                objOut.writeObject(o);
            }
            return packetsIn.toPackets();
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing:" + o, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object packetsToObject(byte[][] packets, boolean zipped) {
        try {
            BytePacketInputStream packetsOut;
            InputStream in = packetsOut = new BytePacketInputStream(packets);
            if (zipped) {
                in = new GZIPInputStream(in);
            }
            try (ObjectInputStream objIn = new ObjectInputStream(in);){
                Object object = objIn.readObject();
                return object;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Error deserializing", e);
        }
    }
}

