/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.client;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.StringIndex;
import com.simsilica.es.client.EntityDataClientService;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.net.CharacterListener;
import mythruna.net.CharacterSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterClientService
extends AbstractClientService
implements CharacterSession {
    static Logger log = LoggerFactory.getLogger(CharacterClientService.class);
    private RmiClientService rmiService;
    private int channel;
    private CharacterSession delegate;
    private EntityId userEntity;
    private EntityId worldEntity;
    private StringIndex strings;
    private CharacterSessionCallback sessionCallback = new CharacterSessionCallback();
    private List<CharacterListener> listeners = new CopyOnWriteArrayList<CharacterListener>();

    public CharacterClientService() {
        this(-2);
    }

    public CharacterClientService(int channel) {
        this.channel = channel;
    }

    protected void threadCheck() {
    }

    @Override
    public EntityId createCharacter(String name, EntityComponent ... components) {
        this.threadCheck();
        return this.getDelegate().createCharacter(name, components);
    }

    @Override
    public void updateCharacter(EntityId character, EntityComponent ... components) {
        this.getDelegate().updateCharacter(character, components);
    }

    @Override
    public String getCharacterPreviewShapeId(EntityComponent ... components) {
        this.threadCheck();
        return this.getDelegate().getCharacterPreviewShapeId(components);
    }

    @Override
    public void runCharacterAction(EntityId character, EntityId target, int actionId, Object ... parms) {
        this.getDelegate().runCharacterAction(character, target, actionId, parms);
    }

    @Override
    public void runCharacterAction(EntityId character, EntityId target, String actionName, Object ... parms) {
        int id = this.strings.getStringId(actionName, false);
        if (id < 0) {
            throw new IllegalArgumentException("No action ID defined for:" + actionName);
        }
        this.runCharacterAction(character, target, id, parms);
    }

    public void addCharacterListener(CharacterListener l) {
        this.listeners.add(l);
    }

    public void removeCharacterListener(CharacterListener l) {
        this.listeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.debug("onInitialize(" + s + ")");
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("ChatClientService requires RMI service");
        }
        log.debug("Sharing session callback.");
        this.rmiService.share((byte)this.channel, (Object)this.sessionCallback, CharacterListener.class);
        this.strings = ((EntityDataClientService)this.getService(EntityDataClientService.class)).getEntityData().getStrings();
    }

    public void start() {
        log.debug("start()");
        super.start();
    }

    private CharacterSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (CharacterSession)this.rmiService.getRemoteObject(CharacterSession.class);
            log.debug("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No character session found");
            }
        }
        return this.delegate;
    }

    private class CharacterSessionCallback
    implements CharacterListener {
        private CharacterSessionCallback() {
        }

        @Override
        public void sessionAvailable() {
            if (log.isTraceEnabled()) {
                log.trace("placeholder()");
            }
            for (CharacterListener l : CharacterClientService.this.listeners) {
                l.sessionAvailable();
            }
        }
    }
}

