/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.path;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import mythruna.world.path.PathNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Path {
    static Logger log = LoggerFactory.getLogger(Path.class);
    private PathNode from;
    private PathNode to;

    public Path(PathNode from, PathNode to) {
        this.from = from;
        this.to = to;
    }

    public PathNode getFrom() {
        return this.from;
    }

    public PathNode getTo() {
        return this.to;
    }

    public PathNode adjacent(PathNode end) {
        if (this.from.equals(end)) {
            return this.to;
        }
        if (this.to.equals(end)) {
            return this.from;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Path other = (Path)o;
        if (!Objects.equals(this.from, other.from)) {
            return false;
        }
        return Objects.equals(this.to, other.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("from", (Object)this.from).add("to", (Object)this.to).toString();
    }
}

