/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.LeafDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDbLeafDbAdapter
implements LeafDb {
    static Logger log = LoggerFactory.getLogger(ColumnDbLeafDbAdapter.class);
    private ColumnDb delegate;

    public ColumnDbLeafDbAdapter(ColumnDb delegate) {
        this.delegate = delegate;
    }

    @Override
    public LeafData loadLeaf(LeafId id) {
        Vec3i world = id.getWorld(null);
        ColumnData column = this.delegate.getColumn(id.getColumnId());
        return column.getLeafData(world.y);
    }

    @Override
    public void storeLeaf(LeafData leaf) {
        LeafId id = leaf.getInfo().leafId;
        log.info("storeLeaf(id:" + id + ")");
        Vec3i world = id.getWorld(null);
        ColumnId columnId = ColumnId.fromWorld(world);
        ColumnData column = this.delegate.getColumn(id.getColumnId());
        column.getVersion().markChanged();
        LeafData original = column.getLeafData(world.y);
        if (original != leaf) {
            throw new RuntimeException("Cache miss?");
        }
        this.delegate.markChanged(column);
    }
}

