/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.transaction;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.DataType;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.transaction.CellEdit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafEdits {
    static Logger log = LoggerFactory.getLogger(LeafEdits.class);
    private static final CellEdit[] EMPTY_ARRAY = new CellEdit[0];
    private static final int CHANGE_THRESHOLD = 10;
    private LeafId leafId;
    private List<CellEdit> blockChanges = new ArrayList<CellEdit>();
    private List<CellEdit> lightChanges = new ArrayList<CellEdit>();
    private List<CellEdit> fluidChanges = new ArrayList<CellEdit>();

    public LeafEdits(LeafId leafId) {
        this.leafId = leafId;
    }

    protected List<CellEdit> collapse(DataType type, List<CellEdit> changes) {
        if (changes.size() <= 10) {
            return changes;
        }
        log.info("Attempting to reduce " + changes.size() + " " + (Object)((Object)type) + " changes");
        long start = System.nanoTime();
        HashMap<Vec3i, CellEdit> index = new HashMap<Vec3i, CellEdit>();
        int removed = 0;
        for (int i = 0; i < changes.size(); ++i) {
            CellEdit edit = changes.get(i);
            Vec3i loc = edit.getCellLocation();
            CellEdit previous = index.put(loc, edit);
            if (previous == null) continue;
            int oldValue = previous.getOldValue();
            int newValue = edit.getValue();
            if (log.isTraceEnabled()) {
                log.trace("loc:" + loc + " oldValue:" + oldValue + " newValue:" + newValue + "  skipping:" + previous.getValue() + "/" + edit.getOldValue());
            }
            if (oldValue == newValue) {
                removed += 2;
                index.remove(loc);
                continue;
            }
            CellEdit newEdit = new CellEdit(edit.getX(), edit.getY(), edit.getZ(), newValue, oldValue);
            ++removed;
            index.put(loc, newEdit);
        }
        if (removed == 0) {
            return changes;
        }
        ArrayList<CellEdit> result = new ArrayList<CellEdit>(index.values());
        long end = System.nanoTime();
        long duration = end - start;
        log.info("Collapsed " + changes.size() + " " + (Object)((Object)type) + " events to:" + result.size() + "  in:" + (double)duration / 1000000.0 + " ms");
        return result;
    }

    public CellChangeEvent createCellChangeEvent() {
        this.blockChanges = this.collapse(DataType.Block, this.blockChanges);
        this.lightChanges = this.collapse(DataType.Light, this.lightChanges);
        this.fluidChanges = this.collapse(DataType.Fluid, this.fluidChanges);
        CellEdit[] blocks = this.blockChanges.isEmpty() ? null : this.blockChanges.toArray(EMPTY_ARRAY);
        CellEdit[] lights = this.lightChanges.isEmpty() ? null : this.lightChanges.toArray(EMPTY_ARRAY);
        CellEdit[] fluids = this.fluidChanges.isEmpty() ? null : this.fluidChanges.toArray(EMPTY_ARRAY);
        return new CellChangeEvent(this.leafId, blocks, lights, fluids);
    }

    public void cellChanged(DataType type, int i, int j, int k, int value, int oldValue) {
        CellEdit edit = new CellEdit((byte)i, (byte)j, (byte)k, value, oldValue);
        switch (type) {
            case Block: {
                this.blockChanges.add(edit);
                break;
            }
            case Light: {
                this.lightChanges.add(edit);
                break;
            }
            case Fluid: {
                this.fluidChanges.add(edit);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Type not yet supported:" + (Object)((Object)type));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[leafId:" + this.leafId + ", #blockChanges:" + this.blockChanges.size() + ", #lightChanges:" + this.lightChanges.size() + ", #fluidChanges:" + this.fluidChanges.size() + "]";
    }
}

