
/**
 *  Base shell API for adding shell commands, etc.
 */

import mythruna.shell.*;

addShellCommand = { CommandShell target, String name, List help, Closure doIt ->
    ShellCommand cmd = new AbstractShellCommand(help as String[]) {
                public Object execute( CommandShell shell, String args ) {
                    // rehydrate(Object delegate, Object owner, Object thisObject)
                    Closure c = doIt.rehydrate(shell, doIt.owner, doIt);
                    int length = doIt.getParameterTypes().length;
                    if( length == 2 ) {
                        c(shell, args);
                    } else {
                        c(args);
                    }
                    return null;
                }
            };
    target.addCommand(name, cmd);
    return cmd;
}

updateShellCommand = { CommandShell target, String name, List help, Closure doIt ->
    ShellCommand cmd = new AbstractShellCommand(help as String[]) {
                public Object execute( CommandShell shell, String args ) {
                    // rehydrate(Object delegate, Object owner, Object thisObject)
                    Closure c = doIt.rehydrate(shell, doIt.owner, doIt);
                    int length = doIt.getParameterTypes().length;
                    if( length == 2 ) {
                        c(shell, args);
                    } else {
                        c(args);
                    }
                    return null;
                }
            };
    target.updateCommand(name, cmd);
    return cmd;
}


