/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.google.common.base.MoreObjects;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEntity
implements Entity {
    static Logger log = LoggerFactory.getLogger(MapEntity.class);
    private EntityId id;
    private Map<Class, EntityComponent> components = new ConcurrentHashMap<Class, EntityComponent>();

    public MapEntity() {
    }

    public MapEntity(Entity presets) {
        this.id = presets.getId();
        for (EntityComponent c : presets.getComponents()) {
            this.set(c);
        }
    }

    public void setId(EntityId id) {
        if (this.id != null) {
            throw new RuntimeException("Cannot reset an entity ID");
        }
        this.id = id;
    }

    public EntityId getId() {
        return this.id;
    }

    public <T extends EntityComponent> T get(Class<T> type) {
        return (T)((EntityComponent)type.cast(this.components.get(type)));
    }

    public void set(EntityComponent c) {
        this.components.put(c.getClass(), c);
    }

    public boolean isComplete() {
        return false;
    }

    public EntityComponent[] getComponents() {
        ArrayList<EntityComponent> values = new ArrayList<EntityComponent>(this.components.values());
        return values.toArray(new EntityComponent[0]);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("id", (Object)this.id).add("components", this.components.values()).toString();
    }
}

