/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.sound;

import java.util.function.Supplier;
import mythruna.client.sound.Audio;
import mythruna.client.sound.Sound;
import mythruna.client.sound.SoundState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAudio
implements Audio {
    static Logger log = LoggerFactory.getLogger(DynamicAudio.class);
    private SoundState sounds;
    private String soundName;
    private boolean looping;
    private Supplier<Double> volumeSupplier;
    private Sound sound;

    public DynamicAudio(SoundState sounds, String soundName) {
        this(sounds, soundName, true);
    }

    public DynamicAudio(SoundState sounds, String soundName, Supplier<Double> volumeSupplier) {
        this(sounds, soundName, true, volumeSupplier);
    }

    public DynamicAudio(SoundState sounds, String soundName, boolean looping) {
        this(sounds, soundName, looping, () -> 1.0);
    }

    public DynamicAudio(SoundState sounds, String soundName, boolean looping, Supplier<Double> volumeSupplier) {
        this.sounds = sounds;
        this.soundName = soundName;
        this.looping = looping;
        this.volumeSupplier = volumeSupplier;
    }

    public void setVolumeSupplier(Supplier<Double> volumeSupplier) {
        this.volumeSupplier = volumeSupplier;
    }

    public Supplier<Double> getVolumeSupplier() {
        return this.volumeSupplier;
    }

    @Override
    public double getVolume() {
        return this.volumeSupplier == null ? 0.0 : this.volumeSupplier.get();
    }

    @Override
    public void update(double baseVolume) {
        double volume = this.getVolume();
        if ((volume *= baseVolume) <= 0.0) {
            if (this.sound != null) {
                this.sounds.stop(this.soundName);
                this.sound = null;
            }
            return;
        }
        if (this.sound == null) {
            this.sound = this.sounds.playAmbient(this.soundName, 0.0f);
            this.sound.setLooping(this.looping);
        }
        if (this.sound.getVolume() != (float)volume) {
            this.sound.setVolume((float)volume);
        }
    }
}

