/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.math.Vector3f;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapPoint
implements VersionedObject<MapPoint> {
    private static final Logger log = LoggerFactory.getLogger(MapPoint.class);
    private static final double EPSILON = 1.0E-5;
    private long version;
    private Vec3d world;
    private VersionedReference<Vec3d> viewOriginRef;
    private VersionedReference<Double> scaleRef;

    public MapPoint(Vec3d world, VersionedObject<Vec3d> viewOrigin, VersionedObject<Double> scale) {
        this.world = world.clone();
        this.viewOriginRef = viewOrigin.createReference();
        this.scaleRef = scale.createReference();
    }

    public void setWorld(Vec3d world) {
        if (this.world.distanceSq(world) <= 1.0E-5) {
            return;
        }
        this.world.set(world);
        ++this.version;
    }

    public Vec3d getWorld() {
        return this.world;
    }

    public double getWorldToViewScale() {
        return (Double)this.scaleRef.get();
    }

    public Vector3f getView() {
        Vec3d rel = this.world.subtract((Vec3d)this.viewOriginRef.get());
        rel.multLocal(((Double)this.scaleRef.get()).doubleValue());
        return new Vector3f((float)rel.x, (float)(-rel.z), 0.0f);
    }

    public MapPoint getObject() {
        return this;
    }

    public long getVersion() {
        return this.version + this.viewOriginRef.getObjectVersion() + this.scaleRef.getObjectVersion();
    }

    public VersionedReference<MapPoint> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.world + "]";
    }
}

