/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shell;

import java.io.Writer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellWriter
extends Writer {
    static Logger log = LoggerFactory.getLogger(ShellWriter.class);
    private Consumer<String> target;
    private StringBuilder line = new StringBuilder();

    public ShellWriter(Consumer<String> target) {
        this.target = target;
    }

    @Override
    public void write(char[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            char c = buffer[offset + i];
            if (c == '\n' || c == '\r') {
                this.flush();
                continue;
            }
            this.line.append(c);
        }
    }

    @Override
    public void flush() {
        if (this.line.length() > 0) {
            this.target.accept(this.line.toString());
            this.line.setLength(0);
        }
    }

    @Override
    public void close() {
        this.flush();
    }
}

