/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;

public class CellDataStack
implements CellData {
    private int elementSize;
    private CellData[] array;

    public CellDataStack(int elementSize, CellData ... array) {
        this.elementSize = elementSize;
        this.array = array;
    }

    public int getMaxY() {
        return this.array.length * this.elementSize;
    }

    public int getCell(int x, int y, int z) {
        int k = y / this.elementSize;
        return this.array[k].getCell(x, y - k * this.elementSize, z);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        int k = y / this.elementSize;
        if (k < 0 || k >= this.array.length) {
            return defaultValue;
        }
        return this.array[k].getCell(x, y - k * this.elementSize, z, defaultValue);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        int k = y / this.elementSize;
        if (k < 0 || k >= this.array.length) {
            return defaultValue;
        }
        return this.array[k].getCell(x, y - k * this.elementSize, z, dir, defaultValue);
    }

    public void setCell(int x, int y, int z, int value) {
        int k = y / this.elementSize;
        if (k < 0 || k >= this.array.length) {
            return;
        }
        this.array[k].setCell(x, y - k * this.elementSize, z, value);
    }
}

