/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.simsilica.lemur.CheckboxModel;
import com.simsilica.lemur.core.VersionedReference;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckboxModelGroup {
    static Logger log = LoggerFactory.getLogger(CheckboxModelGroup.class);
    private Map<CheckboxModel, ModelEntry> models = new LinkedHashMap<CheckboxModel, ModelEntry>();
    private ModelEntry activeEntry;
    private boolean invalid;

    public CheckboxModelGroup() {
    }

    public CheckboxModelGroup(CheckboxModel ... models) {
        this(Arrays.asList(models));
    }

    public CheckboxModelGroup(List<CheckboxModel> models) {
        for (CheckboxModel m : models) {
            this.addModel(m);
        }
    }

    public void addModel(CheckboxModel model) {
        if (this.activeEntry != null && this.activeEntry.model != model) {
            model.setChecked(false);
        }
        this.models.put(model, new ModelEntry(model));
        this.invalid = true;
    }

    public void removeModel(CheckboxModel model) {
        this.models.remove(model);
        if (this.activeEntry == model) {
            this.setActiveEntry(null);
        }
    }

    public CheckboxModel getSelectedModel() {
        return this.activeEntry == null ? null : this.activeEntry.model;
    }

    public void setSelectedModel(CheckboxModel model) {
        ModelEntry entry = this.models.get(model);
        if (entry == null) {
            throw new IllegalArgumentException("Model is not managed by this group:" + model);
        }
        this.setActiveEntry(entry);
    }

    public boolean update() {
        if (this.invalid) {
            this.selectFirst();
            this.invalid = false;
        }
        ModelEntry first = null;
        boolean clear = false;
        for (ModelEntry entry : this.models.values()) {
            if (!entry.ref.update()) continue;
            if (entry.model.isChecked()) {
                if (first != null) continue;
                first = entry;
                continue;
            }
            if (entry != this.activeEntry) continue;
            clear = true;
        }
        if (first != null) {
            this.setActiveEntry(first);
            return true;
        }
        if (clear) {
            this.setActiveEntry(null);
            return true;
        }
        return false;
    }

    protected void selectFirst() {
        for (ModelEntry entry : this.models.values()) {
            if (!entry.model.isChecked()) continue;
            this.setActiveEntry(entry);
            break;
        }
    }

    protected void setActiveEntry(ModelEntry activeEntry) {
        this.activeEntry = activeEntry;
        if (activeEntry == null) {
            return;
        }
        for (ModelEntry entry : this.models.values()) {
            if (entry == activeEntry) continue;
            entry.model.setChecked(false);
        }
    }

    protected class ModelEntry {
        private CheckboxModel model;
        private VersionedReference<Boolean> ref;

        public ModelEntry(CheckboxModel model) {
            this.model = model;
            this.ref = model.createReference();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[model:" + this.model + "]";
        }
    }
}

