/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base.protocol;

import com.jme3.network.Message;
import com.jme3.network.base.MessageBuffer;
import com.jme3.network.base.MessageProtocol;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class GreedyMessageBuffer
implements MessageBuffer {
    private MessageProtocol protocol;
    private final LinkedList<Message> messages = new LinkedList();
    private ByteBuffer current;
    private int size;
    private Byte carry;

    public GreedyMessageBuffer(MessageProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public Message pollMessage() {
        if (this.messages.isEmpty()) {
            return null;
        }
        return this.messages.removeFirst();
    }

    @Override
    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    @Override
    public boolean addBytes(ByteBuffer buffer) {
        while (buffer.remaining() > 0) {
            if (this.current == null) {
                if (this.carry != null) {
                    byte high = this.carry;
                    byte low = buffer.get();
                    this.size = (high & 0xFF) << 8 | low & 0xFF;
                    this.carry = null;
                } else {
                    if (buffer.remaining() < 2) {
                        this.carry = buffer.get();
                        break;
                    }
                    this.size = buffer.getShort();
                }
                this.current = ByteBuffer.allocate(this.size);
            }
            if (this.current.remaining() <= buffer.remaining()) {
                int extra = buffer.remaining() - this.current.remaining();
                buffer.limit(buffer.position() + this.current.remaining());
                this.current.put(buffer);
                this.current.flip();
                buffer.limit(buffer.position() + extra);
                this.messages.add(this.protocol.toMessage(this.current));
                this.current = null;
                continue;
            }
            this.current.put(buffer);
        }
        return this.hasMessages();
    }
}

