/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.Joint;
import com.simsilica.mphys.RigidBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHingeJoint<K, S extends AbstractShape>
implements Joint<K, S> {
    static Logger log = LoggerFactory.getLogger(StaticHingeJoint.class);
    K id;
    RigidBody<K, S> altBody;
    Vec3d altOffset;
    Quatd altRot;
    RigidBody<K, S> mainBody;
    Vec3d mainOffset;
    Quatd mainRot;
    Quatd relativeRotation;
    double damping;
    double test1;
    private Contact<K, S> contact = new Contact();
    private int axis = 0;

    public StaticHingeJoint(K id, RigidBody<K, S> mainBody, Vec3d mainOffset, Quatd mainRot, RigidBody<K, S> altBody, Vec3d altOffset, Quatd altRotation, int axis, double damping, double test1) {
        this.id = id;
        this.altBody = altBody;
        this.altOffset = altOffset;
        this.altRot = this.altRot;
        this.mainBody = mainBody;
        this.mainOffset = mainOffset;
        this.mainRot = mainRot;
        this.axis = axis;
        this.damping = damping;
        this.test1 = test1;
        this.contact.setBodies(mainBody, altBody);
        this.contact.friction = -0.7;
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public RigidBody<K, S> getMainBody() {
        return this.mainBody;
    }

    @Override
    public RigidBody<K, S> getAltBody() {
        return this.altBody;
    }

    @Override
    public RigidBody<K, S> getOtherBody(RigidBody<K, S> body) {
        if (this.mainBody == body) {
            return this.altBody;
        }
        if (this.altBody == body) {
            return this.mainBody;
        }
        throw new IllegalArgumentException("Specified body:" + body.id + " is not part of this joint:" + this.id);
    }

    @Override
    public boolean isSleepy() {
        if (Math.abs(this.contact.penetration) > 1.0E-5) {
            return false;
        }
        return this.mainBody.isSleepy() || this.altBody != null && this.altBody.isSleepy();
    }

    @Override
    public void calculateInternals(double step) {
    }

    @Override
    public void calculatePositionChange(Vec3d linear1, Vec3d linear2, Vec3d angular1, Vec3d angular2) {
    }

    @Override
    public void calculateVelocityChange(Vec3d vDelta1, Vec3d vDelta2, Vec3d rotDelta1, Vec3d rotDelta2) {
    }

    public void resolve2(double step) {
        log.debug("Joint.resolve()");
        log.debug("  pos:" + this.mainBody.position + "  orient:" + this.mainBody.orientation);
        Vec3d world1 = this.altOffset;
        Vec3d world2 = this.mainBody.localToWorld(this.mainOffset);
        Vec3d delta = world1.subtract(world2);
        Vec3d dir = delta.normalize();
        log.debug("  world1:" + world1 + "  world2:" + world2);
        log.debug("  delta:" + delta + "  dir:" + dir);
        this.mainBody.addForceAtPoint(delta.mult(100.0), world2);
    }

    @Override
    public void resolve(double step) {
        this.resolveConstrained(step);
    }

    public void resolveConstrained(double step) {
        log.debug("Joint.resolve()");
        Vec3d world1 = this.altOffset;
        Vec3d world2 = this.mainBody.localToWorld(this.mainOffset);
        Vec3d delta = world1.subtract(world2);
        double length = delta.length();
        if (length == 0.0) {
            log.debug("  delta length:" + length);
            this.contact.penetration = 0.0;
            return;
        }
        Vec3d normal = delta.mult(1.0 / length);
        if (normal.isNaN()) {
            log.warn("Normal is NaN.... length:" + length + "  delta:" + delta + "  world1:" + world1 + "  world2:" + world2);
        }
        double linVelSq = this.mainBody.getLinearVelocity().lengthSq() / this.mainBody.getTemperature();
        double rotVelSq = this.mainBody.getRotationalVelocity().lengthSq() / this.mainBody.getTemperature();
        double originalInvMass = this.mainBody.inverseMass;
        this.contact.setContactInfo(world2, normal, delta.length());
        if (this.test1 > 0.0) {
            this.contact.friction = 0.0;
            this.contact.restitution = 0.0;
        }
        this.contact.matchLocalTemperature();
        this.contact.calculateInternals(step);
        Vec3d linear1 = new Vec3d();
        Vec3d angular1 = new Vec3d();
        Vec3d linear2 = new Vec3d();
        Vec3d angular2 = new Vec3d();
        this.contact.calculatePositionChange(linear1, linear2, angular1, angular2, this.contact.penetration);
        switch (this.axis) {
            case 0: {
                angular1.y = 0.0;
                angular1.z = 0.0;
                break;
            }
            case 1: {
                angular1.x = 0.0;
                angular1.z = 0.0;
                break;
            }
            case 2: {
                angular1.x = 0.0;
                angular1.y = 0.0;
            }
        }
        boolean postCleanup = true;
        this.mainBody.position.addLocal(linear1);
        this.mainBody.orientation.addScaledVectorLocal(angular1, 1.0);
        if (postCleanup) {
            double[] angles = this.mainBody.orientation.toAngles(null);
            switch (this.axis) {
                case 0: {
                    this.mainBody.orientation.fromAngles(angles[0], 0.0, 0.0);
                    break;
                }
                case 1: {
                    this.mainBody.orientation.fromAngles(0.0, angles[1], 0.0);
                    break;
                }
                case 2: {
                    this.mainBody.orientation.fromAngles(0.0, 0.0, angles[2]);
                }
            }
        }
        this.mainBody.calculateDerivedData();
        this.contact.calculateVelocityChange(linear1, linear2, angular1, angular2);
        Vec3d rot = this.mainBody.getRotationalVelocity();
        double slow = this.damping;
        switch (this.axis) {
            case 0: {
                angular1.x -= rot.x * slow;
                angular1.y = -rot.y;
                angular1.z = -rot.z;
                break;
            }
            case 1: {
                angular1.x = -rot.x;
                angular1.y -= rot.y * slow;
                angular1.z = -rot.z;
                break;
            }
            case 2: {
                angular1.x = -rot.x;
                angular1.y = -rot.y;
                angular1.z -= rot.z * slow;
            }
        }
        this.mainBody.addLinearVelocity(linear1);
        this.mainBody.addRotationalVelocity(angular1);
        this.mainBody.inverseMass = originalInvMass;
    }
}

