/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.simsilica.es.EntityData;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import mythruna.world.WorldFractal;
import mythruna.world.tile.Sedectile;
import mythruna.world.tile.SedectileData;
import mythruna.world.tile.Workspace;
import mythruna.world.tile.WorkspaceFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedectileDataGenerator
implements WorkspaceFunction {
    static Logger log = LoggerFactory.getLogger(SedectileDataGenerator.class);
    private WorldFractal worldFractal;
    private EntityData ed;
    private long seed;

    public SedectileDataGenerator(WorldFractal worldFractal, long seed, EntityData ed) {
        this.worldFractal = worldFractal;
        this.ed = ed;
        this.seed = seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Workspace workspace) {
        Vec3i workspaceOrigin = workspace.getOrigin(null);
        log.info("SedectileDataGenerator resolving sedectile base data for workspace:" + workspace + " origin:" + workspaceOrigin);
        String name = String.format("Sedectile generation: %d, %d", workspaceOrigin.x, workspaceOrigin.z);
        ProgressTracker progress = ProgressTrackers.openTracker((String)name);
        try {
            int radius = 2;
            int progressMax = workspace.getSize() * workspace.getSize();
            progress.setMax((double)progressMax);
            for (int xs = -radius; xs <= radius; ++xs) {
                for (int zs = -radius; zs <= radius; ++zs) {
                    Sedectile sedectile = workspace.getSedectile(xs, zs);
                    SedectileId id = sedectile.getSedectileId();
                    SedectileData data = sedectile.getSedectileData();
                    if (data.getGenerationLevel() >= 1) {
                        log.info("Skipping already generated sedectile:" + id);
                        progress.increment();
                        continue;
                    }
                    long start = System.nanoTime();
                    Vec3i sedectileOrigin = id.getWorld(null);
                    data.initialize(this.worldFractal);
                    data.setGenerationLevel(1);
                    long end = System.nanoTime();
                    log.info(String.format("Generated data for %s in %.03f ms", id.getWorld(null).toString(), (double)(end - start) / 1000000.0));
                    progress.increment();
                }
            }
        }
        finally {
            progress.close(true);
        }
    }
}

