/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.tree;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.TileId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileColumnCells
implements CellData {
    static Logger log = LoggerFactory.getLogger(TileColumnCells.class);
    private Vec3i tileOrigin;
    private Vec3i colOrigin;
    private ColumnData colData;
    private LeafData[] leafArray;

    public TileColumnCells(ColumnData colData) {
        this.colData = colData;
        ColumnId colId = colData.getColumnId();
        TileId tileId = colId.getTileId();
        this.tileOrigin = tileId.getWorld(null);
        this.colOrigin = colId.getWorld(null).subtractLocal(this.tileOrigin);
        this.leafArray = colData.getLeafs();
    }

    public ColumnData getColumnData() {
        return this.colData;
    }

    public int getCell(int x, int y, int z) {
        return this.getCell(x, y, z, -1);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        if ((x -= this.colOrigin.x) < 0 || (z -= this.colOrigin.z) < 0) {
            return defaultValue;
        }
        if (x >= 32 || z >= 32) {
            return defaultValue;
        }
        int layer = y / 32;
        return this.leafArray[layer].getCell(x, y -= layer * 32, z);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        Vec3i v = dir.getVec3i();
        return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
    }

    public void setCell(int x, int y, int z, int type) {
        if ((x -= this.colOrigin.x) < 0 || (z -= this.colOrigin.z) < 0) {
            return;
        }
        if (x >= 32 || z >= 32) {
            return;
        }
        int layer = y / 32;
        LeafData leaf = this.leafArray[layer];
        int existing = MaskUtils.getType((int)leaf.getCell(x, y -= layer * 32, z));
        if (existing > 0) {
            return;
        }
        leaf.setCell(x, y, z, type);
    }
}

