/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.VertexBuffer;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.Direction;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeomUtils {
    static Logger log = LoggerFactory.getLogger(GeomUtils.class);

    public static int rotateIndex(int index, int dirDelta) {
        Direction dir = Direction.values()[index];
        dir = dir.rotate(dirDelta);
        return dir.ordinal();
    }

    public static Vec3d rotatePos(Vec3d v, int dirDelta) {
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        v = v.subtract(0.5, 0.5, 0.5);
        v = Direction.getRotation(dirDelta).mult(v, v);
        return v.addLocal(0.5, 0.5, 0.5);
    }

    public static Vec3d rotateDir(Vec3d v, int dirDelta) {
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        return Direction.getRotation(dirDelta).mult(v);
    }

    public static float[] rotatePos(float[] vecs, int dirDelta) {
        if (vecs == null) {
            return null;
        }
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        Vec3d v = new Vec3d();
        float[] result = new float[vecs.length];
        for (int i = 0; i < vecs.length; i += 3) {
            v.set((double)vecs[i], (double)vecs[i + 1], (double)vecs[i + 2]);
            v = v.subtractLocal(0.5, 0.5, 0.5);
            v = Direction.getRotation(dirDelta).mult(v, v);
            v.addLocal(0.5, 0.5, 0.5);
            result[i] = GeomUtils.round(v.x, 1000.0);
            result[i + 1] = GeomUtils.round(v.y, 1000.0);
            result[i + 2] = GeomUtils.round(v.z, 1000.0);
        }
        return result;
    }

    public static float[] rotateDir(float[] vecs, int dirDelta) {
        if (vecs == null) {
            return null;
        }
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        Vec3d v = new Vec3d();
        float[] result = new float[vecs.length];
        for (int i = 0; i < vecs.length; i += 3) {
            v.set((double)vecs[i], (double)vecs[i + 1], (double)vecs[i + 2]);
            v = Direction.getRotation(dirDelta).mult(v, v);
            result[i] = GeomUtils.round(v.x, 1000.0);
            result[i + 1] = GeomUtils.round(v.y, 1000.0);
            result[i + 2] = GeomUtils.round(v.z, 1000.0);
        }
        return result;
    }

    public static float[] rotateUvs(float[] texes, int vertCount, Direction dir, int dirDelta) {
        if (texes == null) {
            return null;
        }
        float[] result = (float[])texes.clone();
        if (dirDelta == 0 || vertCount == 0) {
            return result;
        }
        switch (dir) {
            case North: 
            case South: 
            case East: 
            case West: {
                return result;
            }
            case Down: {
                dirDelta = -dirDelta;
            }
        }
        if ((dirDelta %= 4) < 0) {
            dirDelta += 4;
        }
        Vec3d v = new Vec3d();
        int step = texes.length / vertCount;
        for (int i = 0; i < texes.length; i += step) {
            v.set((double)texes[i] - 0.5, 0.0, (double)texes[i + 1] - 0.5);
            v = Direction.getRotation(dirDelta).mult(v, v);
            v.addLocal(0.5, 0.0, 0.5);
            result[i] = GeomUtils.round(v.x, 1000.0);
            result[i + 1] = GeomUtils.round(v.z, 1000.0);
        }
        return result;
    }

    public static float round(float f, float scale) {
        return (float)Math.round(f * scale) / scale;
    }

    public static float round(double d, double scale) {
        return (float)((double)Math.round(d * scale) / scale);
    }

    public static void carveTextureCoordinates(Node model, float scale) {
        GeomUtils.carveTextureCoordinates(model, scale, Geometry2 -> true);
    }

    public static void carveTextureCoordinates(Node model, final float scale, final Predicate<Geometry> include) {
        model.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                if (include.test(geom)) {
                    GeomUtils.carveTextureCoordinates(geom.getMesh(), scale);
                }
            }
        });
    }

    public static boolean carveTextureCoordinates(Mesh mesh, float scale) {
        VertexBuffer tVb = mesh.getBuffer(VertexBuffer.Type.TexCoord);
        if (tVb == null) {
            log.warn("No uv buffer, skipping carving of mesh:" + mesh);
            return false;
        }
        VertexBuffer pVb = mesh.getBuffer(VertexBuffer.Type.Position);
        if (!(pVb.getData() instanceof FloatBuffer)) {
            log.warn("Pos buffer mismatch, Skipping carving of mesh:" + mesh);
            return false;
        }
        if (!(tVb.getData() instanceof FloatBuffer)) {
            log.warn("UV buffer mismatch, Skipping carving of mesh:" + mesh);
            return false;
        }
        if (pVb.getNumComponents() != 3 || tVb.getNumComponents() != 2) {
            log.warn("Components count mismatch, Skipping carving of mesh:" + mesh);
            return false;
        }
        FloatBuffer pb = (FloatBuffer)pVb.getData();
        pb.rewind();
        FloatBuffer tb = (FloatBuffer)tVb.getData();
        tb.rewind();
        ByteBuffer dirB = null;
        FloatBuffer normB = null;
        VertexBuffer nVb = mesh.getBuffer(VertexBuffer.Type.Normal);
        VertexBuffer dirVb = mesh.getBuffer(VertexBuffer.Type.Size);
        if (nVb == null && dirVb != null) {
            dirB = (ByteBuffer)dirVb.getData();
        } else if (nVb != null) {
            normB = (FloatBuffer)nVb.getData();
        }
        if (dirB == null && normB == null) {
            log.warn("No normal buffer, skipping carving of mesh:" + mesh);
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("pVb elements:" + pVb.getNumElements() + "  components:" + pVb.getNumComponents());
            log.trace("tVb elements:" + tVb.getNumElements() + "  components:" + tVb.getNumComponents());
        }
        Direction[] dirs = Direction.values();
        int count = pVb.getNumElements();
        int basePos = 0;
        int baseUv = 0;
        int baseNorm = 0;
        for (int i = 0; i < count; ++i) {
            float nz;
            float ny;
            float nx;
            float x = pb.get(basePos);
            float y = pb.get(basePos + 1);
            float z = pb.get(basePos + 2);
            if (dirB != null) {
                byte d = dirB.get(baseNorm);
                Vec3i dir = dirs[d].getVec3i();
                nx = dir.x;
                ny = dir.y;
                nz = dir.z;
            } else {
                nx = normB.get(baseNorm);
                ny = normB.get(baseNorm + 1);
                nz = normB.get(baseNorm + 2);
            }
            float u = tb.get(baseUv);
            float v = tb.get(baseUv + 1);
            float left = x;
            float up = z;
            if ((double)Math.abs(ny) < 0.7072) {
                up = y;
                if ((double)Math.abs(nz) < 0.7072) {
                    left = z;
                }
            }
            u = left * scale;
            v = up * scale;
            tb.put(baseUv, u);
            tb.put(baseUv + 1, v);
            basePos += 3;
            baseUv += 2;
            if (dirB != null) {
                ++baseNorm;
                continue;
            }
            baseNorm += 3;
        }
        pb.rewind();
        tb.rewind();
        tVb.updateData((Buffer)tb);
        return true;
    }
}

