/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.progress.view;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ProgressBar;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.Styles;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerView
extends Container {
    static Logger log = LoggerFactory.getLogger(TrackerView.class);
    public static final String ELEMENT_ID = "tracker";
    private ElementId rootElementId;
    private VersionedReference<Collection<ProgressTrackers.ThreadTrackers>> trackerRef;
    private Map<Thread, ThreadView> threadViews = new LinkedHashMap<Thread, ThreadView>();
    private boolean expandOnly = true;
    private boolean alwaysShowDefault = true;
    private float minLabelWidth = 0.0f;
    private boolean forceUpdate = true;
    private Label defaultLabel;
    private ProgressBar defaultProgress;
    private Predicate<Thread> mainThreadFilter;

    public TrackerView() {
        this(true, new ElementId(ELEMENT_ID), null);
    }

    protected TrackerView(boolean applyStyles, ElementId elementId, String style) {
        super(null, false, elementId.child("container"), style);
        this.rootElementId = elementId;
        this.trackerRef = ProgressTrackers.createReference();
        Styles styles = GuiGlobals.getInstance().getStyles();
        if (applyStyles) {
            styles.applyStyles((Object)this, this.getElementId(), style);
        }
        this.defaultLabel = new Label("", elementId.child("thread.title"), style);
        this.defaultProgress = new ProgressBar(elementId.child("thread.progress"), style);
    }

    public void setMainThreadFilter(Predicate<Thread> mainThreadFilter) {
        this.mainThreadFilter = mainThreadFilter;
    }

    public Predicate<Thread> getMainThreadFilter() {
        return this.mainThreadFilter;
    }

    public void setDefaultText(String text) {
        this.defaultLabel.setText(text);
    }

    public String getDefaultText() {
        return this.defaultLabel.getText();
    }

    public boolean isEmpty() {
        return this.threadViews.isEmpty();
    }

    public void setExpandOnly(boolean expandOnly) {
        this.expandOnly = expandOnly;
    }

    public boolean getExpandOnly() {
        return this.expandOnly;
    }

    public void setAlwaysShowDefault(boolean alwaysShowDefault) {
        this.alwaysShowDefault = alwaysShowDefault;
    }

    public boolean getAlwaysShowDefault() {
        return this.alwaysShowDefault;
    }

    public void setMinLabelWidth(float minLabelWidth) {
        this.minLabelWidth = minLabelWidth;
    }

    public float getMinLabelWidth() {
        return this.minLabelWidth;
    }

    public void updateLogicalState(float tpf) {
        if (this.trackerRef.update() || this.forceUpdate) {
            this.updateThreadTrackers((Collection)this.trackerRef.get());
        }
        super.updateLogicalState(tpf);
    }

    protected ElementId threadViewElementId(Thread thread) {
        if (this.mainThreadFilter == null || this.mainThreadFilter.test(thread)) {
            return this.rootElementId.child("thread");
        }
        return this.rootElementId.child("background.thread");
    }

    protected void updateThreadTrackers(Collection<ProgressTrackers.ThreadTrackers> trackers) {
        if (log.isTraceEnabled()) {
            log.trace("updateThreadTrackers() size:" + trackers.size());
        }
        boolean rebuildChildren = false;
        for (ProgressTrackers.ThreadTrackers tracker : trackers) {
            ThreadView view;
            if (log.isTraceEnabled()) {
                log.trace("  checking:" + tracker + " isEmpty():" + tracker.isEmpty());
            }
            if (tracker.isEmpty()) {
                view = this.threadViews.remove(tracker.getThread());
                if (view == null) continue;
                rebuildChildren = true;
                continue;
            }
            view = this.threadViews.get(tracker.getThread());
            if (view == null) {
                view = new ThreadView(tracker, this.threadViewElementId(tracker.getThread()), this.getStyle());
                this.threadViews.put(tracker.getThread(), view);
                rebuildChildren = true;
            }
            view.updateChildren();
        }
        if (rebuildChildren) {
            this.clearChildren();
            for (ThreadView view : this.threadViews.values()) {
                this.addChild((Node)view, new Object[0]);
            }
            if (this.threadViews.isEmpty() && this.alwaysShowDefault) {
                this.addChild((Node)this.defaultLabel, new Object[0]);
                this.addChild((Node)this.defaultProgress, new Object[0]);
            }
        }
    }

    private class ProgressView {
        private ProgressTracker tracker;
        private Label label;
        private ProgressBar bar;
        private VersionedReference<ProgressTracker> ref;
        private boolean invalid;
        private ProgressView child;
        private double childAdd = 0.0;
        private double lastValue = 0.0;

        public ProgressView(ProgressTracker tracker, ElementId elementId, String style) {
            this.label = new Label("", elementId.child("label"), style);
            this.bar = new ProgressBar(elementId.child("progress"), style);
            if (log.isTraceEnabled()) {
                log.trace("ProgressView.label ID:" + this.label.getElementId() + "  bar ID:" + this.bar.getElementId());
            }
            this.updateTracker(tracker);
        }

        protected void updateTracker(ProgressTracker tracker) {
            if (this.tracker == tracker) {
                return;
            }
            this.tracker = tracker;
            if (tracker != null) {
                this.ref = tracker.createReference();
                this.bar.setCullHint(Spatial.CullHint.Inherit);
            } else {
                this.ref = null;
                this.bar.setCullHint(Spatial.CullHint.Always);
            }
            this.childAdd = 0.0;
            this.lastValue = 0.0;
            this.invalid = true;
        }

        protected void setChild(ProgressView child) {
            if (this.child == child) {
                return;
            }
            this.child = child;
        }

        public void update() {
            if (this.invalid || this.ref != null && this.ref.update()) {
                this.invalid = false;
                if (this.tracker == null) {
                    this.label.setText("");
                    this.bar.getModel().setPercent(0.0);
                } else if (!Objects.equals(this.label.getText(), this.tracker.getName())) {
                    if (TrackerView.this.minLabelWidth > 0.0f) {
                        this.label.setPreferredSize(null);
                    }
                    this.label.setText(this.tracker.getName());
                    if (TrackerView.this.minLabelWidth > 0.0f) {
                        Vector3f pref = this.label.getPreferredSize();
                        pref.x = Math.max(TrackerView.this.minLabelWidth, pref.x);
                        this.label.setPreferredSize(pref);
                    }
                }
                if (this.child == null) {
                    this.childAdd = 0.0;
                }
            }
            if (this.tracker == null) {
                return;
            }
            double val = this.tracker.getProgress();
            if (this.child != null) {
                this.childAdd = this.child.tracker.getPercent();
            }
            if ((val = (val + this.childAdd) / this.tracker.getMax()) > this.lastValue) {
                this.bar.getModel().setPercent(val);
                this.lastValue = val;
            }
        }
    }

    private class ThreadView
    extends Container {
        private ProgressTrackers.ThreadTrackers trackers;
        private ElementId mainId;
        private Label mainTitle;
        private Container children;
        private ProgressView main;
        private SafeArrayList<ProgressView> views;

        public ThreadView(ProgressTrackers.ThreadTrackers trackers, ElementId elementId, String style) {
            super(null, elementId.child("container"), style);
            this.views = new SafeArrayList(ProgressView.class);
            this.mainId = elementId;
            this.trackers = trackers;
            this.main = new ProgressView(null, elementId, style);
            this.main.label = (Label)this.addChild((Node)new Label("", elementId.child("title"), style), new Object[0]);
            this.addChild((Node)this.main.bar, new Object[0]);
            this.children = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last)), new Object[0]);
        }

        public void updateChildren() {
            if (log.isTraceEnabled()) {
                log.trace("updateChildren() ProgressTracker main:" + this.main.tracker);
            }
            boolean first = true;
            int index = 0;
            ProgressView last = this.main;
            for (ProgressTracker progress : this.trackers) {
                ProgressView view;
                if (log.isTraceEnabled()) {
                    log.trace("    :" + progress);
                }
                if (first) {
                    this.main.updateTracker(progress);
                    first = false;
                    continue;
                }
                if (index < this.views.size()) {
                    view = (ProgressView)this.views.get(index);
                    view.updateTracker(progress);
                } else {
                    view = new ProgressView(progress, this.mainId.child("child"), this.getStyle());
                    this.views.add((Object)view);
                    this.children.addChild((Node)view.label, new Object[0]);
                    this.children.addChild((Node)view.bar, new Object[]{1});
                }
                last.setChild(view);
                last = view;
                ++index;
            }
            last.setChild(null);
            if (this.views.size() > index) {
                boolean rebuildChildren = false;
                for (int i = index; i < this.views.size(); ++i) {
                    if (TrackerView.this.expandOnly) {
                        ((ProgressView)this.views.get(i)).updateTracker(null);
                        continue;
                    }
                    this.views.remove(i);
                    rebuildChildren = true;
                }
                if (rebuildChildren) {
                    this.children.clearChildren();
                    for (ProgressView view : this.views) {
                        this.children.addChild((Node)view.label, new Object[0]);
                        this.children.addChild((Node)view.bar, new Object[]{1});
                    }
                }
            }
        }

        public void updateLogicalState(float tpf) {
            this.main.update();
            for (ProgressView view : (ProgressView[])this.views.getArray()) {
                view.update();
            }
            super.updateLogicalState(tpf);
        }
    }
}

