/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import java.util.Arrays;
import java.util.List;

public class TextureArray
extends Texture {
    private Texture.WrapMode wrapS = Texture.WrapMode.EdgeClamp;
    private Texture.WrapMode wrapT = Texture.WrapMode.EdgeClamp;

    public TextureArray() {
    }

    public TextureArray(List<Image> images) {
        int width = images.get(0).getWidth();
        int height = images.get(0).getHeight();
        Image.Format format = images.get(0).getFormat();
        ColorSpace colorSpace = images.get(0).getColorSpace();
        int[] mipMapSizes = images.get(0).getMipMapSizes();
        Image arrayImage = new Image(format, width, height, null, colorSpace);
        arrayImage.setMipMapSizes(mipMapSizes);
        for (Image img : images) {
            if (img.getHeight() != height || img.getWidth() != width) {
                throw new IllegalArgumentException("Images in texture array must have same dimensions");
            }
            if (img.getFormat() != format) {
                throw new IllegalArgumentException("Images in texture array must have same format");
            }
            if (!Arrays.equals(mipMapSizes, img.getMipMapSizes())) {
                throw new IllegalArgumentException("Images in texture array must have same mipmap sizes");
            }
            arrayImage.addData(img.getData(0));
        }
        this.setImage(arrayImage);
    }

    @Override
    public Texture createSimpleClone() {
        TextureArray clone = new TextureArray();
        this.createSimpleClone(clone);
        return clone;
    }

    @Override
    public Texture createSimpleClone(Texture rVal) {
        rVal.setWrap(Texture.WrapAxis.S, this.wrapS);
        rVal.setWrap(Texture.WrapAxis.T, this.wrapT);
        return super.createSimpleClone(rVal);
    }

    @Override
    public Texture.Type getType() {
        return Texture.Type.TwoDimensionalArray;
    }

    @Override
    public Texture.WrapMode getWrap(Texture.WrapAxis axis) {
        switch (axis) {
            case S: {
                return this.wrapS;
            }
            case T: {
                return this.wrapT;
            }
        }
        throw new IllegalArgumentException("invalid WrapAxis: " + (Object)((Object)axis));
    }

    @Override
    public void setWrap(Texture.WrapAxis axis, Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        if (axis == null) {
            throw new IllegalArgumentException("axis can not be null.");
        }
        switch (axis) {
            case S: {
                this.wrapS = mode;
                break;
            }
            case T: {
                this.wrapT = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not applicable for 2D textures");
            }
        }
    }

    @Override
    public void setWrap(Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        this.wrapS = mode;
        this.wrapT = mode;
    }
}

