/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys.net;

import com.simsilica.es.EntityId;
import com.simsilica.ethereal.zone.ZoneManager;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.ObjectStatusAdapter;
import com.simsilica.ext.mphys.net.ZoneNetworkListener;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.PhysicsListener;
import com.simsilica.mphys.RigidBody;
import com.simsilica.sim.AbstractGameSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneNetworkSystem<S extends AbstractShape>
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(ZoneNetworkSystem.class);
    private ZoneManager zones;
    private PhysicsObserver physicsObserver = new PhysicsObserver();
    private DynArray<ZoneNetworkListener> listeners = new DynArray(ZoneNetworkListener.class);

    public ZoneNetworkSystem(ZoneManager zones) {
        this.zones = zones;
    }

    public ZoneManager getZones() {
        return this.zones;
    }

    public void addZoneNetworkListener(ZoneNetworkListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners.add((Object)l);
    }

    public void removeZoneNetworkListener(ZoneNetworkListener l) {
        this.listeners.remove((Object)l);
    }

    protected void initialize() {
        ((MPhysSystem)((Object)this.getSystem(MPhysSystem.class))).addPhysicsListener(this.physicsObserver);
        ((MPhysSystem)((Object)this.getSystem(MPhysSystem.class))).getBinEntityManager().addObjectStatusListener(this.physicsObserver);
    }

    protected void terminate() {
        ((MPhysSystem)((Object)this.getSystem(MPhysSystem.class))).removePhysicsListener(this.physicsObserver);
        ((MPhysSystem)((Object)this.getSystem(MPhysSystem.class))).getBinEntityManager().removeObjectStatusListener(this.physicsObserver);
    }

    private class PhysicsObserver
    extends ObjectStatusAdapter<S>
    implements PhysicsListener<EntityId, S> {
        private Vec3d pos = new Vec3d();
        private Quatd orient = new Quatd();

        public void startFrame(long frameTime, double stepSize) {
            ZoneNetworkSystem.this.zones.beginUpdate(frameTime);
            for (ZoneNetworkListener l : (ZoneNetworkListener[])ZoneNetworkSystem.this.listeners.getArray()) {
                l.beginUpdate(frameTime);
            }
        }

        public void endFrame() {
            for (ZoneNetworkListener l : (ZoneNetworkListener[])ZoneNetworkSystem.this.listeners.getArray()) {
                l.endUpdate();
            }
            ZoneNetworkSystem.this.zones.endUpdate();
        }

        public void update(RigidBody<EntityId, S> body) {
            if (log.isTraceEnabled()) {
                log.trace("update(" + body.id + ", " + body.isSleepy() + ")");
            }
            boolean active = !body.isSleepy();
            Vec3d pos = body.shape.getWorldShapeOrigin(body);
            ZoneNetworkSystem.this.zones.updateEntity(Long.valueOf(((EntityId)body.id).getId()), active, pos, body.orientation, body.getWorldBounds());
        }

        @Override
        public void objectLoaded(EntityId id, RigidBody<EntityId, S> body) {
            if (log.isTraceEnabled()) {
                log.trace("objectAdded(" + id + ", " + body + ")");
            }
        }

        @Override
        public void objectUnloaded(EntityId id, RigidBody<EntityId, S> body) {
            if (log.isTraceEnabled()) {
                log.trace("objectRemoved(" + id + ", " + body + ")");
            }
            ZoneNetworkSystem.this.zones.remove(Long.valueOf(id.getId()));
        }
    }
}

