/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mythruna.world.tile.LocalRegionIndex;
import mythruna.world.tile.RegionIndexType;
import mythruna.world.tile.WorldRegion;
import mythruna.world.tile.WorldRegionIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionManager {
    static Logger log = LoggerFactory.getLogger(RegionManager.class);
    private LoadingCache<LocalRegionId, LocalRegionIndex> localRegions;
    private Map<RegionIndexType, WorldRegionIndex> worldRegions = new HashMap<RegionIndexType, WorldRegionIndex>();

    public RegionManager() {
        this.localRegions = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<LocalRegionId, LocalRegionIndex>(){

            public LocalRegionIndex load(LocalRegionId id) {
                return RegionManager.this.loadLocalRegionIndex(id);
            }
        });
    }

    public LocalRegionIndex getLocalRegionIndex(RegionIndexType type, SedectileId sedectileId) {
        return (LocalRegionIndex)this.localRegions.getUnchecked((Object)new LocalRegionId(this, type, sedectileId));
    }

    public LocalRegionIndex getLocalRegionIndex(RegionIndexType type, Vec3i world) {
        return this.getLocalRegionIndex(type, SedectileId.fromWorld((Vec3i)world));
    }

    protected WorldRegionIndex getWorldRegions(RegionIndexType type) {
        WorldRegionIndex result = this.worldRegions.get(type);
        if (result == null) {
            result = new WorldRegionIndex();
            this.worldRegions.put(type, result);
        }
        return result;
    }

    public WorldRegionIndex getWorldRegionIndex(RegionIndexType type) {
        return this.getWorldRegions(type);
    }

    public WorldRegion createWorldRegion(RegionIndexType type) {
        return this.getWorldRegions(type).createRegion();
    }

    public WorldRegion getWorldRegion(RegionIndexType type, long id) {
        return this.getWorldRegions(type).getRegion(id);
    }

    protected LocalRegionIndex loadLocalRegionIndex(LocalRegionId id) {
        return new LocalRegionIndex(id.sedectileId, id.type);
    }

    private class LocalRegionId {
        private RegionIndexType type;
        private SedectileId sedectileId;

        public LocalRegionId(RegionManager regionManager, RegionIndexType type, SedectileId sedectileId) {
            this.type = type;
            this.sedectileId = sedectileId;
        }

        public int hashCode() {
            return Objects.hash(this.sedectileId, this.type);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            LocalRegionId other = (LocalRegionId)o;
            if (!Objects.equals(other.sedectileId, this.sedectileId)) {
                return false;
            }
            return Objects.equals(other.type, this.type);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[sedectileId:" + this.sedectileId + ", type:" + this.type + "]";
        }
    }
}

