/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.Joint;
import com.jme3.anim.MatrixJointModelTransform;
import com.jme3.anim.SeparateJointModelTransform;
import com.jme3.anim.util.JointModelTransform;
import com.jme3.asset.AssetLoadException;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix4f;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Armature
implements JmeCloneable,
Savable {
    private Joint[] rootJoints;
    private Joint[] jointList;
    private transient Matrix4f[] skinningMatrixes;
    private Class<? extends JointModelTransform> modelTransformClass = SeparateJointModelTransform.class;

    protected Armature() {
    }

    public Armature(Joint[] jointList) {
        int i;
        this.jointList = jointList;
        ArrayList<Joint> rootJointList = new ArrayList<Joint>();
        for (i = jointList.length - 1; i >= 0; --i) {
            Joint joint = jointList[i];
            joint.setId(i);
            this.instantiateJointModelTransform(joint);
            if (joint.getParent() != null) continue;
            rootJointList.add(joint);
        }
        this.rootJoints = rootJointList.toArray(new Joint[rootJointList.size()]);
        this.createSkinningMatrices();
        for (i = this.rootJoints.length - 1; i >= 0; --i) {
            Joint rootJoint = this.rootJoints[i];
            rootJoint.update();
        }
    }

    public void update() {
        for (Joint rootJoint : this.rootJoints) {
            rootJoint.update();
        }
    }

    private void createSkinningMatrices() {
        this.skinningMatrixes = new Matrix4f[this.jointList.length];
        for (int i = 0; i < this.skinningMatrixes.length; ++i) {
            this.skinningMatrixes[i] = new Matrix4f();
        }
    }

    public void setModelTransformClass(Class<? extends JointModelTransform> modelTransformClass) {
        this.modelTransformClass = modelTransformClass;
        if (this.jointList == null) {
            return;
        }
        for (Joint joint : this.jointList) {
            this.instantiateJointModelTransform(joint);
        }
    }

    private void instantiateJointModelTransform(Joint joint) {
        try {
            joint.setJointModelTransform(this.modelTransformClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Joint[] getRoots() {
        return this.rootJoints;
    }

    public List<Joint> getJointList() {
        return Arrays.asList(this.jointList);
    }

    public Joint getJoint(int index) {
        return this.jointList[index];
    }

    public Joint getJoint(String name) {
        for (int i = 0; i < this.jointList.length; ++i) {
            if (!this.jointList[i].getName().equals(name)) continue;
            return this.jointList[i];
        }
        return null;
    }

    public int getJointIndex(Joint joint) {
        for (int i = 0; i < this.jointList.length; ++i) {
            if (this.jointList[i] != joint) continue;
            return i;
        }
        return -1;
    }

    public int getJointIndex(String name) {
        for (int i = 0; i < this.jointList.length; ++i) {
            if (!this.jointList[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void saveBindPose() {
        this.update();
        for (Joint joint : this.jointList) {
            joint.saveBindPose();
        }
    }

    public void applyBindPose() {
        for (Joint joint : this.rootJoints) {
            joint.applyBindPose();
        }
    }

    public void saveInitialPose() {
        for (Joint joint : this.jointList) {
            joint.saveInitialPose();
        }
    }

    public void applyInitialPose() {
        for (Joint rootJoint : this.rootJoints) {
            rootJoint.applyInitialPose();
        }
    }

    public Matrix4f[] computeSkinningMatrices() {
        for (int i = 0; i < this.jointList.length; ++i) {
            this.jointList[i].getOffsetTransform(this.skinningMatrixes[i]);
        }
        return this.skinningMatrixes;
    }

    public int getJointCount() {
        return this.jointList.length;
    }

    @Override
    public Object jmeClone() {
        try {
            Armature clone = (Armature)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.rootJoints = cloner.clone(this.rootJoints);
        this.jointList = cloner.clone(this.jointList);
        this.skinningMatrixes = cloner.clone(this.skinningMatrixes);
        for (Joint joint : this.jointList) {
            this.instantiateJointModelTransform(joint);
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule input = im.getCapsule(this);
        Savable[] jointRootsAsSavable = input.readSavableArray("rootJoints", null);
        this.rootJoints = new Joint[jointRootsAsSavable.length];
        System.arraycopy(jointRootsAsSavable, 0, this.rootJoints, 0, jointRootsAsSavable.length);
        Savable[] jointListAsSavable = input.readSavableArray("jointList", null);
        this.jointList = new Joint[jointListAsSavable.length];
        System.arraycopy(jointListAsSavable, 0, this.jointList, 0, jointListAsSavable.length);
        String className = input.readString("modelTransformClass", MatrixJointModelTransform.class.getCanonicalName());
        try {
            this.modelTransformClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new AssetLoadException("Cannot find class for name " + className);
        }
        int i = 0;
        for (Joint joint : this.jointList) {
            joint.setId(i++);
            this.instantiateJointModelTransform(joint);
        }
        this.createSkinningMatrices();
        for (Joint rootJoint : this.rootJoints) {
            rootJoint.update();
        }
        this.applyInitialPose();
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule output = ex.getCapsule(this);
        output.write(this.rootJoints, "rootJoints", null);
        output.write(this.jointList, "jointList", null);
        output.write(this.modelTransformClass.getCanonicalName(), "modelTransformClass", MatrixJointModelTransform.class.getCanonicalName());
    }
}

