/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.google.common.base.Function;
import com.simsilica.lemur.value.DefaultValueRenderer;

public class ValueRenderers {
    public static <T> DefaultValueRenderer<T> toStringRenderer(String nullValue) {
        return new DefaultValueRenderer<Object>(ValueRenderers.toString(nullValue));
    }

    public static <T> DefaultValueRenderer<T> formattedRenderer(String format, String nullValue) {
        return new DefaultValueRenderer<Object>(ValueRenderers.formatString(format, nullValue));
    }

    public static Function<Object, String> toString(String nullValue) {
        return new SafeToString(nullValue);
    }

    public static Function<Object, String> formatString(String format) {
        return ValueRenderers.formatString(format, null);
    }

    public static Function<Object, String> formatString(String format, String nullValue) {
        return new FormatString(format, nullValue);
    }

    public static class FormatString
    implements Function<Object, String> {
        private String format;
        private String nullString;

        public FormatString(String format, String nullString) {
            this.format = format;
            this.nullString = nullString;
        }

        public String apply(Object value) {
            if (value == null && this.nullString != null) {
                return this.nullString;
            }
            return String.format(this.format, value);
        }
    }

    public static class SafeToString
    implements Function<Object, String> {
        private String nullString;

        public SafeToString(String nullString) {
            this.nullString = nullString;
        }

        public String apply(Object value) {
            return value == null ? this.nullString : String.valueOf(value);
        }
    }
}

