/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.text;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public class TextFilters {
    private static IsDigit IS_DIGIT = new IsDigit();
    private static IsLetter IS_LETTER = new IsLetter();
    private static Function<Character, Character> ALPHA = TextFilters.charFilter(IS_LETTER);
    private static Function<Character, Character> NUMERIC = TextFilters.charFilter(IS_DIGIT);
    private static Function<Character, Character> ALPHA_NUMERIC = TextFilters.charFilter((Predicate<Character>)Predicates.or((Predicate)IS_DIGIT, (Predicate)IS_LETTER));
    private static ToLowerCase TO_LOWER_CASE = new ToLowerCase();
    private static ToUpperCase TO_UPPER_CASE = new ToUpperCase();

    public static Function<String, String> constantTransform(char c) {
        return new ConstantOutputTransform(c);
    }

    public static Function<String, String> upperCaseTransform() {
        return new CharOutputTransform(TO_UPPER_CASE);
    }

    public static Function<String, String> lowerCaseTransform() {
        return new CharOutputTransform(TO_LOWER_CASE);
    }

    public static Function<String, String> charOutputTransform(Function<Character, Character> transform) {
        return new CharOutputTransform(transform);
    }

    public static Function<Character, Character> alpha() {
        return ALPHA;
    }

    public static Function<Character, Character> numeric() {
        return NUMERIC;
    }

    public static Function<Character, Character> alphaNumeric() {
        return ALPHA_NUMERIC;
    }

    public static Function<Character, Character> charFilter(Predicate<Character> predicate) {
        return new CharFilter(predicate);
    }

    public static Function<Character, Character> toUpperCase() {
        return TO_UPPER_CASE;
    }

    public static Function<Character, Character> toLowerCase() {
        return TO_LOWER_CASE;
    }

    public static Predicate<Character> isLetter() {
        return IS_LETTER;
    }

    public static Predicate<Character> isDigit() {
        return IS_DIGIT;
    }

    public static Predicate<Character> isLetterOrDigit() {
        return Predicates.or(TextFilters.isLetter(), TextFilters.isDigit());
    }

    public static Predicate<Character> isInChars(char ... chars) {
        return new IsInChars(chars);
    }

    private static class IsInChars
    implements Predicate<Character> {
        private char[] chars;

        public IsInChars(char[] chars) {
            this.chars = chars;
        }

        public boolean apply(Character c) {
            for (char check : this.chars) {
                if (c.charValue() != check) continue;
                return true;
            }
            return false;
        }
    }

    private static class IsLetter
    implements Predicate<Character> {
        private IsLetter() {
        }

        public boolean apply(Character c) {
            return Character.isLetter(c.charValue());
        }
    }

    private static class IsDigit
    implements Predicate<Character> {
        private IsDigit() {
        }

        public boolean apply(Character c) {
            return Character.isDigit(c.charValue());
        }
    }

    private static class ToLowerCase
    implements Function<Character, Character> {
        private ToLowerCase() {
        }

        public Character apply(Character c) {
            return Character.valueOf(Character.toLowerCase(c.charValue()));
        }
    }

    private static class ToUpperCase
    implements Function<Character, Character> {
        private ToUpperCase() {
        }

        public Character apply(Character c) {
            return Character.valueOf(Character.toUpperCase(c.charValue()));
        }
    }

    private static class CharFilter
    implements Function<Character, Character> {
        private Predicate<Character> predicate;

        public CharFilter(Predicate<Character> predicate) {
            this.predicate = predicate;
        }

        public Character apply(Character c) {
            return this.predicate.apply((Object)c) ? c : null;
        }
    }

    private static class CharOutputTransform
    implements Function<String, String> {
        private Function<Character, Character> transform;

        public CharOutputTransform(Function<Character, Character> transform) {
            this.transform = transform;
        }

        public String apply(String input) {
            if (input == null) {
                return null;
            }
            if (input.length() == 0) {
                return input;
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < input.length(); ++i) {
                Character c = Character.valueOf(input.charAt(i));
                if (c == null) continue;
                result.append(this.transform.apply((Object)c));
            }
            return result.toString();
        }
    }

    private static class ConstantOutputTransform
    implements Function<String, String> {
        private char output;

        public ConstantOutputTransform(char output) {
            this.output = output;
        }

        public String apply(String input) {
            if (input == null) {
                return null;
            }
            if (input.length() == 0) {
                return input;
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c == '\r' || c == '\n') {
                    result.append(c);
                    continue;
                }
                result.append(this.output);
            }
            return result.toString();
        }
    }
}

