/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd.bits;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec4d;
import com.simsilica.mathd.bits.FloatBits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuatBits {
    static Logger log = LoggerFactory.getLogger(QuatBits.class);
    private final FloatBits componentBits;
    private final int yShift;
    private final int zShift;
    private final int wShift;
    private final int totalBits;
    private long mask;

    public QuatBits(int componentBitSize) {
        this.componentBits = new FloatBits(-1.0f, 1.0f, componentBitSize);
        this.yShift = componentBitSize;
        this.zShift = this.yShift + componentBitSize;
        this.wShift = this.zShift + componentBitSize;
        this.totalBits = this.wShift + componentBitSize;
        if (this.totalBits > 64) {
            throw new IllegalArgumentException("Total bit size exceeds 64");
        }
        this.mask = this.componentBits.getMask();
        this.mask |= this.componentBits.getMask() << this.yShift;
        this.mask |= this.componentBits.getMask() << this.zShift;
        this.mask |= this.componentBits.getMask() << this.wShift;
        if (log.isTraceEnabled()) {
            log.trace("Bit size:" + this.totalBits + "  mask:" + Long.toHexString(this.mask));
        }
    }

    public int getComponentBitSize() {
        return this.componentBits.getBitSize();
    }

    public int getBitSize() {
        return this.totalBits;
    }

    public long getMask() {
        return this.mask;
    }

    public long toBits(Quatd q) {
        long x = this.componentBits.toBits((float)q.x);
        long y = this.componentBits.toBits((float)q.y);
        long z = this.componentBits.toBits((float)q.z);
        long w = this.componentBits.toBits((float)q.w);
        long result = x;
        result |= y << this.yShift;
        result |= z << this.zShift;
        return result |= w << this.wShift;
    }

    public Quatd fromBits(long bits) {
        long x = bits & this.componentBits.getMask();
        long y = bits >> this.yShift & this.componentBits.getMask();
        long z = bits >> this.zShift & this.componentBits.getMask();
        long w = bits >> this.wShift & this.componentBits.getMask();
        float xf = this.componentBits.fromBits(x);
        float yf = this.componentBits.fromBits(y);
        float zf = this.componentBits.fromBits(z);
        float wf = this.componentBits.fromBits(w);
        return new Quatd(xf, yf, zf, wf);
    }

    public static void main(String ... args) {
        Quatd quat = new Quatd();
        QuatBits qBits = new QuatBits(12);
        double max = Math.PI * 2;
        double delta = max / 250.0;
        Vec4d minValues = new Vec4d(10.0, 10.0, 10.0, 10.0);
        Vec4d maxValues = new Vec4d(-10.0, -10.0, -10.0, -10.0);
        Vec4d temp = new Vec4d();
        Vec4d maxError = new Vec4d(0.0, 0.0, 0.0, 0.0);
        long start = System.nanoTime();
        int count = 0;
        for (double x = 0.0; x < max; x += delta) {
            for (double y = 0.0; y < max; y += delta) {
                for (double z = 0.0; z < max; z += delta) {
                    quat.fromAngles(x, y, z);
                    quat.normalizeLocal();
                    temp.set(quat.x, quat.y, quat.z, quat.w);
                    minValues.minLocal(temp);
                    maxValues.maxLocal(temp);
                    long value = qBits.toBits(quat);
                    Quatd test = qBits.fromBits(value);
                    long value2 = qBits.toBits(test);
                    if (value != value2) {
                        System.out.println("Double convert failed...");
                        System.out.println("original:" + quat);
                        System.out.println("    test:" + test);
                        return;
                    }
                    quat.subtractLocal(test);
                    temp.set(Math.abs(quat.x), Math.abs(quat.y), Math.abs(quat.z), Math.abs(quat.w));
                    maxError.maxLocal(temp);
                    ++count;
                }
            }
            System.out.println((int)(x / max * 100.0) + "%");
        }
        System.out.println();
        long end = System.nanoTime();
        System.out.println("Completed in " + (double)(end - start) / 1000000.0 + " ms    per iteration:" + (double)((end - start) / (long)count) / 1000000.0 + " ms");
        System.out.println("min:" + minValues);
        System.out.println("max:" + maxValues);
        System.out.println("error rate:" + maxError);
    }
}

