/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.geom;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import mythruna.client.view.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointMesh
extends Mesh {
    static Logger log = LoggerFactory.getLogger(PointMesh.class);
    private Point[] points;

    public PointMesh(Point ... points) {
        this.setMode(Mesh.Mode.Points);
        this.points = points;
        this.initialize();
        this.update();
    }

    protected void initialize() {
        int numParticles = this.points.length;
        FloatBuffer pb = BufferUtils.createVector3Buffer((int)numParticles);
        VertexBuffer buf = this.getBuffer(VertexBuffer.Type.Position);
        if (buf != null) {
            buf.updateData((Buffer)pb);
        } else {
            VertexBuffer pvb = new VertexBuffer(VertexBuffer.Type.Position);
            pvb.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, (Buffer)pb);
            this.setBuffer(pvb);
        }
        ByteBuffer cb = BufferUtils.createByteBuffer((int)(numParticles * 4));
        buf = this.getBuffer(VertexBuffer.Type.Color);
        if (buf != null) {
            buf.updateData((Buffer)cb);
        } else {
            VertexBuffer cvb = new VertexBuffer(VertexBuffer.Type.Color);
            cvb.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.UnsignedByte, (Buffer)cb);
            cvb.setNormalized(true);
            this.setBuffer(cvb);
        }
        FloatBuffer sb = BufferUtils.createFloatBuffer((int)numParticles);
        buf = this.getBuffer(VertexBuffer.Type.Size);
        if (buf != null) {
            buf.updateData((Buffer)sb);
        } else {
            VertexBuffer svb = new VertexBuffer(VertexBuffer.Type.Size);
            svb.setupData(VertexBuffer.Usage.Stream, 1, VertexBuffer.Format.Float, (Buffer)sb);
            this.setBuffer(svb);
        }
        FloatBuffer tb = BufferUtils.createFloatBuffer((int)(numParticles * 4));
        buf = this.getBuffer(VertexBuffer.Type.TexCoord);
        if (buf != null) {
            buf.updateData((Buffer)tb);
        } else {
            VertexBuffer tvb = new VertexBuffer(VertexBuffer.Type.TexCoord);
            tvb.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.Float, (Buffer)tb);
            this.setBuffer(tvb);
        }
        this.updateCounts();
    }

    public void update() {
        VertexBuffer pvb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer positions = (FloatBuffer)pvb.getData();
        VertexBuffer cvb = this.getBuffer(VertexBuffer.Type.Color);
        ByteBuffer colors = (ByteBuffer)cvb.getData();
        VertexBuffer svb = this.getBuffer(VertexBuffer.Type.Size);
        FloatBuffer sizes = (FloatBuffer)svb.getData();
        VertexBuffer tvb = this.getBuffer(VertexBuffer.Type.TexCoord);
        FloatBuffer texcoords = (FloatBuffer)tvb.getData();
        float sizeScale = 1.0f;
        positions.rewind();
        colors.rewind();
        sizes.rewind();
        texcoords.rewind();
        for (Point p : this.points) {
            positions.put(p.x).put(p.y).put(p.z);
            sizes.put(p.size * sizeScale);
            colors.putInt(p.color);
            texcoords.put(p.u1).put(p.v1).put(p.u2).put(p.v2);
        }
        positions.flip();
        colors.flip();
        sizes.flip();
        texcoords.flip();
        pvb.updateData((Buffer)positions);
        cvb.updateData((Buffer)colors);
        svb.updateData((Buffer)sizes);
        tvb.updateData((Buffer)texcoords);
    }
}

