/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.anim;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.simsilica.lemur.anim.AbstractTween;
import com.simsilica.lemur.anim.Tween;

public class CameraTweens {
    public static Tween move(Camera target, Vector3f from, Vector3f to) {
        from = from != null ? from : target.getLocation();
        to = to != null ? to : target.getLocation();
        return new MoveCamera(target, from, to);
    }

    public static Tween move(Camera target, Vector3f from, Vector3f to, double length) {
        from = from != null ? from : target.getLocation();
        to = to != null ? to : target.getLocation();
        return new MoveCamera(target, from, to, length);
    }

    public static Tween rotate(Camera target, Quaternion from, Quaternion to, double length) {
        from = from != null ? from : target.getRotation();
        to = to != null ? to : target.getRotation();
        return new RotateCamera(target, from, to, length);
    }

    private static class RotateCamera
    extends AbstractTween {
        private final Camera target;
        private final Quaternion from;
        private final Quaternion to;
        private final Quaternion value;

        public RotateCamera(Camera target, Quaternion from, Quaternion to, double length) {
            super(length);
            this.target = target;
            this.from = from.clone();
            this.to = to.clone();
            this.value = from.clone();
        }

        @Override
        protected void doInterpolate(double t) {
            this.value.slerp(this.from, this.to, (float)t);
            this.target.setRotation(this.value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[target=" + this.target + ", from=" + this.from + ", to=" + this.to + ", length=" + this.getLength() + "]";
        }
    }

    private static class MoveCamera
    extends AbstractTween {
        private final Camera target;
        private final Vector3f from;
        private final Vector3f to;
        private final Vector3f value;

        public MoveCamera(Camera target, Vector3f from, Vector3f to) {
            this(target, from, to, to.distance(from));
        }

        public MoveCamera(Camera target, Vector3f from, Vector3f to, double length) {
            super(length);
            this.target = target;
            this.from = from.clone();
            this.to = to.clone();
            this.value = new Vector3f(from);
        }

        @Override
        protected void doInterpolate(double t) {
            this.value.interpolateLocal(this.from, this.to, (float)t);
            this.target.setLocation(this.value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[target=" + this.target + ", from=" + this.from + ", to=" + this.to + ", length=" + this.getLength() + "]";
        }
    }
}

