/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.style;

import com.jme3.util.clone.Cloner;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.StyleTree;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Styles {
    static Logger log = LoggerFactory.getLogger(Styles.class);
    public static final String ROOT_STYLE = "root";
    public static final ElementId DEFAULT_ELEMENT = new ElementId("default");
    private static Map<Class, List<Method>> methodIndex = new HashMap<Class, List<Method>>();
    private Set<Class> initialized = new HashSet<Class>();
    private Map<String, StyleTree> styleTrees = new HashMap<String, StyleTree>();
    private Map<String, Attributes> attributeMap = new HashMap<String, Attributes>();
    private Map<Class, Object> defaults = new HashMap<Class, Object>();
    private String defaultStyle = "root";

    public void setDefaultStyle(String style) {
        if (style == null) {
            style = ROOT_STYLE;
        }
        this.defaultStyle = style;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public void clearCache() {
        this.attributeMap.clear();
    }

    public void setDefault(Object value) {
        this.defaults.put(value.getClass(), value);
    }

    public <T> T getDefault(Class<T> type) {
        return (T)this.defaults.get(type);
    }

    public Attributes getAttributes(ElementId elementId) {
        return this.getAttributes(elementId, null);
    }

    public Attributes getAttributes(ElementId elementId, String style) {
        String key;
        Attributes result;
        if (style == null) {
            style = this.defaultStyle;
        }
        if ((result = this.attributeMap.get(key = this.styleKey(elementId, style))) == null) {
            result = this.getTree(style, true).getAttributes(elementId);
            if (!DEFAULT_ELEMENT.equals(elementId)) {
                result = result.merge(this.getTree(style, true).getAttributes(DEFAULT_ELEMENT));
            }
            if (!ROOT_STYLE.equals(style)) {
                Attributes toMerge = this.getAttributes(elementId, ROOT_STYLE);
                result = result.merge(toMerge);
            }
            this.attributeMap.put(key, result);
        }
        return result;
    }

    public Attributes getAttributes(String elementId) {
        return this.getAttributes(new ElementId(elementId), null);
    }

    public Attributes getAttributes(String elementId, String style) {
        return this.getAttributes(new ElementId(elementId), style);
    }

    protected String styleKey(ElementId elementId, String style) {
        if (style == null || style.equals(ROOT_STYLE)) {
            return elementId.getId();
        }
        return style + ":" + elementId.getId();
    }

    protected StyleTree getTree(String style, boolean create) {
        StyleTree tree;
        if (style == null) {
            style = ROOT_STYLE;
        }
        if ((tree = this.styleTrees.get(style)) == null && create) {
            tree = new StyleTree(this);
            this.styleTrees.put(style, tree);
        }
        return tree;
    }

    public Attributes getSelector(String style) {
        return this.getSelector(DEFAULT_ELEMENT, style);
    }

    public Attributes getSelector(ElementId id, String style) {
        this.clearCache();
        return this.getTree(style, true).getSelector(id, true);
    }

    public Attributes getSelector(String id, String style) {
        return this.getSelector(new ElementId(id), style);
    }

    public Attributes getSelector(ElementId parent, ElementId child, String style) {
        this.clearCache();
        return this.getTree(style, true).getSelector(parent, child, true);
    }

    public Attributes getSelector(ElementId parent, String child, String style) {
        return this.getSelector(parent, new ElementId(child), style);
    }

    public Attributes getSelector(String parent, ElementId child, String style) {
        return this.getSelector(new ElementId(parent), child, style);
    }

    public Attributes getSelector(String parent, String child, String style) {
        return this.getSelector(new ElementId(parent), new ElementId(child), style);
    }

    public static void main(String ... args) {
        ElementId id = new ElementId("slider.thumb.button");
        System.out.println("Parts:" + Arrays.asList(id.getParts()));
        Styles test = new Styles();
        test.getSelector("slider.thumb.button", null).set("color", "red");
        test.getSelector("thumb", "button", null).set("background", "angry");
        test.getSelector("slider.thumb.button", "foo").set("background", "happy");
        test.getSelector("button", null).set("border", "outline");
        test.getSelector("button", "foo").set("border", "dotted");
        test.getSelector("slider", "button", null).set("action", "depress");
        test.getSelector("button", "foo").set("action", "null");
        test.getSelector("foo").set("color", "yellow");
        Attributes a1 = test.getAttributes("slider.thumb.button", ROOT_STYLE);
        System.out.println("a1:" + a1);
        Attributes a2 = test.getAttributes("slider.thumb.button", "foo");
        System.out.println("a2:" + a2);
    }

    public void initializeStyles(Class c) {
        Method[] methods;
        if (this.initialized.contains(c)) {
            return;
        }
        this.initialized.add(c);
        if (c.getSuperclass() != Object.class) {
            this.initializeStyles(c.getSuperclass());
        }
        for (Method m : methods = c.getMethods()) {
            int mods = m.getModifiers();
            if (!Modifier.isStatic(mods) || !Modifier.isPublic(mods) || !m.isAnnotationPresent(StyleDefaults.class)) continue;
            StyleDefaults styleDefaults = m.getAnnotation(StyleDefaults.class);
            try {
                Class<?>[] parmTypes = m.getParameterTypes();
                Object[] args = new Object[parmTypes.length];
                for (int i = 0; i < parmTypes.length; ++i) {
                    if (Styles.class.isAssignableFrom(parmTypes[i])) {
                        args[i] = this;
                        continue;
                    }
                    if (!Attributes.class.isAssignableFrom(parmTypes[i])) continue;
                    args[i] = this.getSelector(styleDefaults.value(), null);
                }
                m.invoke((Object)c, args);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error initializing styles for:" + c, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error initializing styles for:" + c, e);
            }
        }
    }

    protected Object getExistingValue(Object o, Method m) {
        Class<?> c = o.getClass();
        String name = m.getName();
        if (!name.startsWith("set")) {
            return null;
        }
        name = "g" + name.substring(1);
        try {
            m = c.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return m.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error getting existing value from:" + m + " on:" + o, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error getting existing value from:" + m + " on:" + o, e);
        }
    }

    protected static List<Method> getStyleAttributeMethods(Class c) {
        List<Method> results = methodIndex.get(c);
        if (results != null) {
            return results;
        }
        results = new ArrayList<Method>();
        for (Method m : c.getMethods()) {
            if (!m.isAnnotationPresent(StyleAttribute.class)) continue;
            StyleAttribute attribute = m.getAnnotation(StyleAttribute.class);
            results.add(m);
        }
        methodIndex.put(c, results);
        return results;
    }

    @Deprecated
    public void applyStyles(Object o, String elementId) {
        this.applyStyles(o, new ElementId(elementId), null);
    }

    @Deprecated
    public void applyStyles(Object o, String elementId, String style) {
        this.applyStyles(o, new ElementId(elementId), style);
    }

    public void applyStyles(Object o, ElementId elementId) {
        this.applyStyles(o, elementId, null);
    }

    public void applyStyles(Object o, ElementId elementId, String style) {
        Class<?> c = o.getClass();
        this.initializeStyles(c);
        if (log.isTraceEnabled()) {
            log.trace("applyStyles elementId:" + elementId + " style:" + style + (style == null ? "(" + this.defaultStyle + ")" : ""));
        }
        Attributes attrs = this.getAttributes(elementId, style);
        if (log.isTraceEnabled()) {
            log.trace("style attributes:" + attrs);
        }
        Object cloner = null;
        for (Method m : Styles.getStyleAttributeMethods(c)) {
            StyleAttribute attribute = m.getAnnotation(StyleAttribute.class);
            Class<?> type = m.getParameterTypes()[0];
            Object value = attrs.get(attribute.value(), type, attribute.lookupDefault());
            if (value == null) continue;
            Object original = value;
            value = this.clone(value, null);
            if (log.isTraceEnabled() && original != value) {
                log.trace("Cloned value.\nOriginal:" + original + "\nClone:" + value);
            }
            try {
                if (log.isTraceEnabled()) {
                    log.trace("calling " + m.getName() + " with:" + value);
                }
                m.invoke(o, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error applying attribute:" + attribute + " to:" + o, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error applying attribute:" + attribute + " to:" + o, e);
            }
        }
    }

    protected Object clone(Object value, Cloner cloner) {
        if (value instanceof GuiComponent) {
            if (log.isTraceEnabled()) {
                log.trace("Cloning GuiComponent:" + value);
            }
            if (cloner != null) {
                if (cloner.isCloned(value)) {
                    return cloner.clone(value);
                }
                GuiComponent result = ((GuiComponent)value).clone();
                cloner.setClonedValue(value, (Object)result);
                return result;
            }
            return ((GuiComponent)value).clone();
        }
        if (value instanceof List) {
            if (log.isTraceEnabled()) {
                log.trace("Attempting to clone list:" + value);
            }
            return this.cloneList((List)value, cloner == null ? new Cloner() : cloner);
        }
        if (value instanceof Map) {
            if (log.isTraceEnabled()) {
                log.trace("Attempting to clone map:" + value);
            }
            return this.cloneMap((Map)value, cloner == null ? new Cloner() : cloner);
        }
        if (value instanceof Cloneable) {
            if (log.isTraceEnabled()) {
                log.trace("Attempting to clone value:" + value);
            }
            if (cloner == null) {
                cloner = new Cloner();
            }
            return cloner.clone(value);
        }
        return value;
    }

    protected Map<Object, Object> cloneMap(Map<Object, Object> source, Cloner cloner) {
        if (cloner.isCloned(source)) {
            return (Map)cloner.clone(source);
        }
        Map<Object, Object> result = null;
        for (Map.Entry<Object, Object> e : source.entrySet()) {
            Object clone;
            Object value = e.getValue();
            if (value == (clone = this.clone(value, cloner))) continue;
            if (result == null) {
                if (source instanceof Cloneable) {
                    try {
                        result = (Map)cloner.javaClone(source);
                    }
                    catch (CloneNotSupportedException ex) {
                        log.warn("Map implementation cannot be cloned:" + source.getClass() + " values:" + source, (Throwable)ex);
                        result = new HashMap<Object, Object>(source);
                    }
                } else {
                    result = new HashMap<Object, Object>(source);
                }
            }
            result.put(e.getKey(), clone);
        }
        if (result != null) {
            cloner.setClonedValue(source, result);
            return result;
        }
        return source;
    }

    protected List<Object> cloneList(List<Object> source, Cloner cloner) {
        if (cloner.isCloned(source)) {
            return (List)cloner.clone(source);
        }
        List<Object> result = null;
        for (int i = 0; i < source.size(); ++i) {
            Object value = source.get(i);
            Object clone = this.clone(value, cloner);
            if (clone == value) continue;
            if (result == null) {
                if (source instanceof Cloneable) {
                    try {
                        result = (List)cloner.javaClone(source);
                    }
                    catch (CloneNotSupportedException e) {
                        log.warn("List implementation cannot be cloned:" + source.getClass() + " values:" + source, (Throwable)e);
                        result = new ArrayList<Object>(source);
                    }
                } else {
                    result = new ArrayList<Object>(source);
                }
            }
            result.set(i, clone);
        }
        if (result != null) {
            cloner.setClonedValue(source, result);
            return result;
        }
        return source;
    }
}

