/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import mythruna.world.tile.LocalRegion;
import mythruna.world.tile.RegionIndexType;
import mythruna.world.tile.SedectileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRegionIndex {
    static Logger log = LoggerFactory.getLogger(LocalRegionIndex.class);
    public static final int SIZE = 128;
    private SedectileId sedectileId;
    private RegionIndexType indexType;
    private LocalRegion[] array = new LocalRegion[16384];
    private Map<Integer, LocalRegion> idIndex = new HashMap<Integer, LocalRegion>();
    private boolean initialized;

    public LocalRegionIndex(SedectileId sedectileId, RegionIndexType indexType) {
        this.sedectileId = sedectileId;
        this.indexType = indexType;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private int index(int x, int z) {
        return z * 128 + x;
    }

    public SedectileId getSedectileId() {
        return this.sedectileId;
    }

    public RegionIndexType getIndexType() {
        return this.indexType;
    }

    public LocalRegion getRegion(int x, int z) {
        return this.array[this.index(x, z)];
    }

    public Collection<LocalRegion> getRegions() {
        return this.idIndex.values();
    }

    protected LocalRegion mergeRegions(LocalRegion region1, LocalRegion region2) {
        LocalRegion with;
        LocalRegion replace;
        if (region1 == region2) {
            log.warn("Merged regions are the same");
            return region1;
        }
        if (region1.getLocalId() < region2.getLocalId()) {
            replace = region2;
            with = region1;
        } else if (region1.getLocalId() > region2.getLocalId()) {
            replace = region1;
            with = region2;
        } else {
            throw new IllegalArgumentException("Different regions have the same ID, region1:" + region1 + ", region2:" + region2);
        }
        with.addAllPoints(replace.getPoints());
        for (Vec3i p : replace.getPoints()) {
            this.array[this.index((int)p.x, (int)p.z)] = with;
        }
        this.idIndex.remove(replace.getLocalId());
        return with;
    }

    protected LocalRegion createRegion(int localId, int type) {
        LocalRegion region = new LocalRegion(this.sedectileId, localId, type);
        this.idIndex.put(localId, region);
        return region;
    }

    public void initialize(SedectileData tile) {
        int count = 128;
        int[][] types = this.indexType.createTypes(tile);
        int nextRegionId = 0;
        LocalRegion lastRegion = null;
        for (int x = 1; x < count; ++x) {
            int type = types[x][0];
            if (type == -1) {
                lastRegion = null;
                continue;
            }
            if (lastRegion == null || lastRegion.getType() != type) {
                lastRegion = this.createRegion(nextRegionId++, type);
            }
            this.array[this.index((int)x, (int)0)] = lastRegion;
            lastRegion.addPoint(new Vec3i(x, 0, 0));
        }
        for (int z = 1; z < count; ++z) {
            for (int x = 0; x < count; ++x) {
                LocalRegion region;
                int type = types[x][z];
                if (type == -1) continue;
                LocalRegion left = null;
                if (x > 0 && type == types[x - 1][z]) {
                    left = this.array[this.index(x - 1, z)];
                }
                LocalRegion up = null;
                if (type == types[x][z - 1]) {
                    up = this.array[this.index(x, z - 1)];
                }
                if (up == null && left == null) {
                    region = this.createRegion(nextRegionId++, type);
                } else if (up == left) {
                    region = up;
                } else if (up != null && left != null) {
                    region = this.mergeRegions(up, left);
                } else if (up == null) {
                    region = left;
                } else if (left == null) {
                    region = up;
                } else {
                    throw new RuntimeException("Invalid neighbor state, this should never happen.");
                }
                this.array[this.index((int)x, (int)z)] = region;
                region.addPoint(new Vec3i(x, 0, z));
            }
        }
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        sorted.addAll(this.idIndex.keySet());
        int index = 0;
        for (Integer id : sorted) {
            if (id != index) {
                LocalRegion r = this.idIndex.remove(id);
                r.setLocalId(index);
                this.idIndex.put(index, r);
            }
            ++index;
        }
        this.initialized = true;
    }
}

