/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileColumnProcessor;
import com.simsilica.mworld.tile.TileManager;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileBasedColumnGenerator
implements Function<ColumnId, ColumnData> {
    static Logger log = LoggerFactory.getLogger(TileBasedColumnGenerator.class);
    private TileManager tiles;
    private int leafCount;
    private TileColumnProcessor[] processors;

    public TileBasedColumnGenerator(TileManager tiles, int leafCount, TileColumnProcessor ... processors) {
        this.tiles = tiles;
        this.leafCount = leafCount;
        this.processors = processors;
    }

    @Override
    public ColumnData apply(ColumnId columnId) {
        TileId tileId = columnId.getTileId();
        Tile tile = this.tiles.getTile(tileId, Resolution.High);
        ColumnData result = this.createEmptyColumnData(columnId);
        boolean changed = false;
        for (TileColumnProcessor proc : this.processors) {
            if (!proc.apply(result, tile)) continue;
            changed = true;
        }
        return result;
    }

    protected ColumnData createEmptyColumnData(ColumnId colId) {
        return new ColumnData(colId, this.leafCount);
    }
}

