/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.simsilica.fractal.AbstractCellularSampler;
import com.simsilica.fractal.CellularNoise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvertedCellularNoise
extends AbstractCellularSampler {
    static Logger log = LoggerFactory.getLogger(CellularNoise.class);
    private boolean simple = true;

    public InvertedCellularNoise() {
        this(0L, true);
    }

    public InvertedCellularNoise(long seed) {
        this(seed, true);
    }

    public InvertedCellularNoise(boolean simple) {
        this(0L, simple);
    }

    public InvertedCellularNoise(long seed, boolean simple) {
        super(seed, 0.0, 1.0);
        this.simple = simple;
    }

    @Override
    public double getSample(double x, double y, double z) {
        double d;
        double xf = x % 1.0;
        double zf = z % 1.0;
        double xCell = Math.floor(x);
        double zCell = Math.floor(z);
        double min = Double.POSITIVE_INFINITY;
        double nextMin = 0.0;
        double xBest = 0.0;
        double zBest = 0.0;
        double xNextBest = 0.0;
        double zNextBest = 0.0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                double zn;
                double zd;
                double xn = this.getRandomX(xCell + (double)i, zCell + (double)j) + (double)i;
                double xd = xn - xf;
                d = xd * xd + (zd = (zn = this.getRandomZ(xCell + (double)i, zCell + (double)j) + (double)j) - zf) * zd;
                if (d < min) {
                    nextMin = min;
                    xNextBest = xBest;
                    zNextBest = zBest;
                    min = d;
                    xBest = xd;
                    zBest = zd;
                    continue;
                }
                if (!(d < nextMin)) continue;
                nextMin = d;
                xNextBest = xd;
                zNextBest = zd;
            }
        }
        if (this.simple) {
            return Math.abs(Math.sqrt(min) - Math.sqrt(nextMin));
        }
        double xDelta = xNextBest - xBest;
        double zDelta = zNextBest - zBest;
        double length = Math.sqrt(xDelta * xDelta + zDelta * zDelta);
        double xmp = (xBest + xNextBest) * 0.5;
        double zmp = (zBest + zNextBest) * 0.5;
        d = xmp * (xDelta *= 1.0 / length) + zmp * (zDelta *= 1.0 / length);
        return d;
    }
}

