/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mod;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModInfo {
    static Logger log = LoggerFactory.getLogger(ModInfo.class);
    private static final String FORMAT_VERSION = "1.0";
    private String groupId;
    private String name;
    private String author;
    private String version;
    private String formatVersion;
    private Boolean enabled;
    private List<String> dependencies;
    private List<String> initScripts;
    private List<String> terminateScripts;
    private List<String> resources;
    private Map<String, Object> config;

    public ModInfo() {
    }

    public ModInfo(String groupId, String name, String ... initScripts) {
        this.groupId = groupId;
        this.name = name;
        this.initScripts = Arrays.asList(initScripts);
        this.upgrade();
    }

    public String getId() {
        return this.groupId + ":" + this.name;
    }

    protected void upgrade() {
        if (this.initScripts == null) {
            this.initScripts = new ArrayList<String>(Arrays.asList("initialize.groovy"));
        }
        if (this.terminateScripts == null) {
            this.terminateScripts = new ArrayList<String>();
        }
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        if (this.config == null) {
            this.config = new HashMap<String, Object>();
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isEnabled() {
        return this.enabled == null ? true : this.enabled;
    }

    public List<String> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public List<String> getInitScripts() {
        return Collections.unmodifiableList(this.initScripts);
    }

    public List<String> getTerminateScripts() {
        return Collections.unmodifiableList(this.terminateScripts);
    }

    public List<String> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("groupId", (Object)this.groupId).add("name", (Object)this.name).add("author", (Object)this.author).add("version", (Object)this.version).add("dependencies", this.dependencies).add("initScripts", this.initScripts).add("config", this.config).toString();
    }
}

