/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.dnd;

import com.jme3.collision.CollisionResult;
import com.jme3.math.Vector2f;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.dnd.DragAndDropControl;
import com.simsilica.lemur.dnd.DragEvent;
import com.simsilica.lemur.dnd.DragSession;
import com.simsilica.lemur.dnd.DragStatus;
import com.simsilica.lemur.dnd.Draggable;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultDragSession
implements DragSession {
    private Spatial source;
    private Map<String, Object> attributes;
    private Draggable draggable;
    private DragStatus status;
    private Spatial dropTarget;
    private Vector2f dragLocation;
    private CollisionResult collision;

    public DefaultDragSession(Spatial source, Vector2f dragLocation) {
        this.source = source;
        this.dragLocation = dragLocation;
    }

    @Override
    public void set(String name, Object attribute) {
        if (this.attributes == null) {
            if (attribute == null) {
                return;
            }
            this.attributes = new LinkedHashMap<String, Object>();
        }
        this.attributes.put(name, attribute);
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        if (this.attributes == null) {
            return defaultValue;
        }
        Object result = this.attributes.get(name);
        return (T)(result != null ? result : defaultValue);
    }

    @Override
    public boolean hasAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    @Override
    public Spatial getDragSource() {
        return this.source;
    }

    protected void setDraggable(Draggable draggable) {
        if (this.draggable != null) {
            throw new IllegalStateException("Session already has a draggable defined.");
        }
        this.draggable = draggable;
    }

    @Override
    public Draggable getDraggable() {
        return this.draggable;
    }

    @Override
    public void setDragStatus(DragStatus status) {
        if (this.status == status) {
            return;
        }
        this.status = status;
        this.draggable.updateDragStatus(status);
    }

    @Override
    public DragStatus getDragStatus() {
        return this.status;
    }

    protected void close(DragEvent event) {
        if (this.dropTarget != null) {
            if (this.status == DragStatus.ValidTarget) {
                ((DragAndDropControl)this.dropTarget.getControl(DragAndDropControl.class)).fireDrop(event);
            }
            ((DragAndDropControl)this.dropTarget.getControl(DragAndDropControl.class)).fireExit(event);
            if (this.status != DragStatus.ValidTarget) {
                this.dropTarget = null;
            }
        }
        if (this.source != null) {
            ((DragAndDropControl)this.source.getControl(DragAndDropControl.class)).fireDone(event);
        }
        this.draggable.release();
    }

    protected void setDropTarget(Spatial dropTarget, DragEvent event) {
        if (this.dropTarget == dropTarget) {
            return;
        }
        if (this.dropTarget != null) {
            ((DragAndDropControl)this.dropTarget.getControl(DragAndDropControl.class)).fireExit(event);
        }
        this.dropTarget = dropTarget;
        if (this.dropTarget != null) {
            this.setDragStatus(DragStatus.InvalidTarget);
            ((DragAndDropControl)this.dropTarget.getControl(DragAndDropControl.class)).fireEnter(event);
        } else {
            this.setDragStatus(DragStatus.NoTarget);
        }
    }

    @Override
    public Spatial getDropTarget() {
        return this.dropTarget;
    }

    @Override
    public Vector2f getDragLocation() {
        return this.dragLocation;
    }

    protected void setDropCollision(CollisionResult collision) {
        this.collision = collision;
    }

    @Override
    public CollisionResult getDropCollision() {
        return this.collision;
    }
}

