/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.props;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.CheckboxModel;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultCheckboxModel;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.Slider;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.Styles;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class PropertyPanel
extends Panel
implements VersionedObject<PropertyPanel> {
    public static final ElementId ELEMENT_ID = new ElementId("properties");
    private BorderLayout layout;
    private Container container;
    private List<AbstractProperty> properties = new ArrayList<AbstractProperty>();
    private AbstractProperty[] propertyArray;
    private Object enabledBean;
    private Checkbox enabledCheckbox;
    private CheckboxModel enabledModel = new EnabledCheckboxModel();
    private PropertyDescriptor enabledProperty;
    private long version;

    public PropertyPanel(String style) {
        this(true, ELEMENT_ID, style);
    }

    public PropertyPanel(ElementId elementId, String style) {
        this(true, elementId, style);
    }

    protected PropertyPanel(boolean applyStyles, ElementId elementId, String style) {
        super(false, elementId, style);
        this.layout = new BorderLayout();
        ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)this.layout);
        this.container = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last), elementId.child("container"), style);
        this.layout.addChild((Node)this.container, new Object[]{BorderLayout.Position.Center});
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, elementId, style);
        }
    }

    protected AbstractProperty[] getArray() {
        if (this.propertyArray == null) {
            this.propertyArray = new AbstractProperty[this.properties.size()];
            this.propertyArray = this.properties.toArray(this.propertyArray);
        }
        return this.propertyArray;
    }

    public void refresh() {
        for (AbstractProperty p : this.getArray()) {
            p.refresh();
        }
    }

    public Container getContainer() {
        return this.container;
    }

    protected PropertyDescriptor findProperty(Object bean, String propertyName) {
        try {
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (!pd.getName().equals(propertyName)) continue;
                if (pd.getReadMethod() == null) {
                    throw new RuntimeException("Property has no read method:" + propertyName + " on:" + bean.getClass());
                }
                if (pd.getWriteMethod() == null) {
                    throw new RuntimeException("Property has no write method:" + propertyName + " on:" + bean.getClass());
                }
                return pd;
            }
            throw new RuntimeException("No suche property:" + propertyName + " on:" + bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Error introspecting object", e);
        }
    }

    protected Field findField(Object bean, String fieldName) {
        try {
            return bean.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("Error inspecting object", ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Error inspecting object", ex);
        }
    }

    protected void addProperty(AbstractProperty p) {
        p.initialize(this.container);
        this.properties.add(p);
        this.propertyArray = null;
    }

    protected void resetEnabled() {
        if (this.enabledCheckbox == null) {
            this.enabledCheckbox = new Checkbox("", this.enabledModel, this.getElementId().child("enabled.checkbox"), this.getStyle());
            this.enabledModel.setChecked(((Boolean)this.getPropertyValue(this.enabledProperty, this.enabledBean)).booleanValue());
        } else {
            this.setPropertyValue(this.enabledProperty, this.enabledBean, this.enabledModel.isChecked());
        }
    }

    public CheckboxModel setEnabledProperty(Object bean, String property) {
        this.enabledProperty = this.findProperty(bean, property);
        this.enabledBean = bean;
        this.resetEnabled();
        return this.enabledModel;
    }

    public CheckboxModel getEnabledModel() {
        return this.enabledModel;
    }

    public Property<Boolean> addBooleanProperty(String name, Object bean, String property) {
        BooleanProperty p = new BooleanProperty(name, (Access<Boolean>)new PropertyAccess<Boolean>(bean, property));
        this.addProperty(p);
        return p;
    }

    public Property<Float> addFloatProperty(String name, Object bean, String property, float min, float max, float step) {
        FloatProperty p = new FloatProperty(name, new PropertyAccess<Float>(bean, property), min, max, step);
        this.addProperty(p);
        return p;
    }

    public Property<Double> addDoubleProperty(String name, Object bean, String property, double min, double max, double step) {
        DoubleProperty p = new DoubleProperty(name, new PropertyAccess<Double>(bean, property), min, max, step);
        this.addProperty(p);
        return p;
    }

    public Property<Integer> addIntProperty(String name, Object bean, String proprety, int min, int max, int step) {
        IntProperty p = new IntProperty(name, new PropertyAccess<Integer>(bean, proprety), min, max, step);
        this.addProperty(p);
        return p;
    }

    public Property<Enum> addEnumProperty(String name, Object bean, String property) {
        EnumProperty p = new EnumProperty(name, (Access<Enum>)new PropertyAccess<Enum>(bean, property));
        this.addProperty(p);
        return p;
    }

    public Property<Boolean> addBooleanField(String name, Object bean, String field) {
        BooleanProperty p = new BooleanProperty(name, (Access<Boolean>)new FieldAccess<Boolean>(bean, field));
        this.addProperty(p);
        return p;
    }

    public Property<Float> addFloatField(String name, Object bean, String field, float min, float max, float step) {
        FloatProperty p = new FloatProperty(name, new FieldAccess<Float>(bean, field), min, max, step);
        this.addProperty(p);
        return p;
    }

    public Property<Double> addDoubleField(String name, Object bean, String field, double min, double max, double step) {
        DoubleProperty p = new DoubleProperty(name, new FieldAccess<Double>(bean, field), min, max, step);
        this.addProperty(p);
        return p;
    }

    public Property<Integer> addIntField(String name, Object bean, String field, int min, int max, int step) {
        IntProperty p = new IntProperty(name, new FieldAccess<Integer>(bean, field), min, max, step);
        this.addProperty(p);
        return p;
    }

    public Property<Enum> addEnumField(String name, Object bean, String field) {
        EnumProperty p = new EnumProperty(name, (Access<Enum>)new FieldAccess<Enum>(bean, field));
        this.addProperty(p);
        return p;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        for (AbstractProperty p : this.getArray()) {
            p.update();
        }
    }

    protected <T> T getPropertyValue(PropertyDescriptor pd, Object bean) {
        try {
            return (T)pd.getReadMethod().invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error getting value", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error getting value", e);
        }
    }

    protected void setPropertyValue(PropertyDescriptor pd, Object bean, Object value) {
        try {
            pd.getWriteMethod().invoke(bean, value);
            ++this.version;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error setting value", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error setting value", e);
        }
    }

    protected <T> T getFieldValue(Field field, Object bean) {
        try {
            return (T)field.get(bean);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error getting value", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error getting value", e);
        }
    }

    protected void setFieldValue(Field field, Object bean, Object value) {
        try {
            field.set(bean, value);
            ++this.version;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error setting value", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error setting value", e);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public PropertyPanel getObject() {
        return this;
    }

    public VersionedReference<PropertyPanel> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    protected class EnumProperty
    extends AbstractProperty<Enum> {
        private Label label;
        private Label valueText;
        private Slider slider;
        private RangedValueModel model;
        private VersionedReference<Double> value;
        private Class type;
        private Enum[] values;

        public EnumProperty(String name, Access<Enum> access) {
            super(name, access);
            this.type = access.getType();
            this.values = (Enum[])this.type.getEnumConstants();
            this.model = new DefaultRangedValueModel(0.0, (double)(this.values.length - 1), 0.0);
        }

        @Override
        public void initialize(Container container) {
            this.label = new Label(this.getDisplayName() + ":", PropertyPanel.this.getElementId().child("enum.label"), PropertyPanel.this.getStyle());
            this.label.setTextHAlignment(HAlignment.Right);
            this.slider = new Slider(this.model, Axis.X, PropertyPanel.this.getElementId().child("enum.slider"), PropertyPanel.this.getStyle());
            this.refresh();
            this.valueText = new Label("", PropertyPanel.this.getElementId().child("value.label"), PropertyPanel.this.getStyle());
            this.updateText();
            this.value = this.slider.getModel().createReference();
            container.addChild((Node)this.label, new Object[0]);
            container.addChild((Node)this.valueText, new Object[]{1});
            container.addChild((Node)this.slider, new Object[]{2});
        }

        protected void updateText() {
            int index = (int)this.model.getValue();
            this.valueText.setText(String.valueOf(this.values[index]));
        }

        @Override
        public void update() {
            if (this.value.update()) {
                int i = (int)this.model.getValue();
                super.setValue(this.values[i]);
                this.updateText();
            }
        }

        @Override
        public void refresh() {
            Enum current = (Enum)this.getValue();
            int index = current.ordinal();
            this.model.setValue((double)index);
        }
    }

    protected class IntProperty
    extends AbstractProperty<Integer> {
        private Label label;
        private Label valueText;
        private Slider slider;
        private RangedValueModel model;
        private int step;
        private VersionedReference<Double> value;
        private String format;

        public IntProperty(String name, Access<Integer> access, int min, int max, int step) {
            super(name, access);
            this.format = "%14d";
            this.model = new DefaultRangedValueModel((double)min, (double)max, 0.0);
            this.step = step;
        }

        @Override
        public void initialize(Container container) {
            this.label = new Label(this.getDisplayName() + ":", PropertyPanel.this.getElementId().child("int.label"), PropertyPanel.this.getStyle());
            this.label.setTextHAlignment(HAlignment.Right);
            this.slider = new Slider(this.model, Axis.X, PropertyPanel.this.getElementId().child("int.slider"), PropertyPanel.this.getStyle());
            this.slider.setDelta((double)this.step);
            this.refresh();
            this.valueText = new Label("", PropertyPanel.this.getElementId().child("value.label"), PropertyPanel.this.getStyle());
            this.updateText();
            this.value = this.slider.getModel().createReference();
            container.addChild((Node)this.label, new Object[0]);
            container.addChild((Node)this.valueText, new Object[]{1});
            container.addChild((Node)this.slider, new Object[]{2});
        }

        protected void updateText() {
            this.valueText.setText(String.format(this.format, Math.round(this.model.getValue())));
        }

        @Override
        public void update() {
            if (this.value.update()) {
                super.setValue((int)this.model.getValue());
                this.updateText();
            }
        }

        @Override
        public void refresh() {
            Integer current = (Integer)this.getValue();
            this.model.setValue((double)current.intValue());
        }
    }

    protected class DoubleProperty
    extends AbstractProperty<Double> {
        private Label label;
        private Label valueText;
        private Slider slider;
        private RangedValueModel model;
        private double step;
        private VersionedReference<Double> value;
        private String format;

        public DoubleProperty(String name, Access<Double> access, double min, double max, double step) {
            super(name, access);
            this.format = "%14.3f";
            this.model = new DefaultRangedValueModel(min, max, 0.0);
            this.step = step;
        }

        @Override
        public void initialize(Container container) {
            this.label = new Label(this.getDisplayName() + ":", PropertyPanel.this.getElementId().child("double.label"), PropertyPanel.this.getStyle());
            this.label.setTextHAlignment(HAlignment.Right);
            this.slider = new Slider(this.model, Axis.X, PropertyPanel.this.getElementId().child("double.slider"), PropertyPanel.this.getStyle());
            this.slider.setDelta(this.step);
            this.refresh();
            this.valueText = new Label("", PropertyPanel.this.getElementId().child("value.label"), PropertyPanel.this.getStyle());
            this.updateText();
            this.value = this.slider.getModel().createReference();
            container.addChild((Node)this.label, new Object[0]);
            container.addChild((Node)this.valueText, new Object[]{1});
            container.addChild((Node)this.slider, new Object[]{2});
        }

        protected void updateText() {
            this.valueText.setText(String.format(this.format, this.model.getValue()));
        }

        @Override
        public void update() {
            if (this.value.update()) {
                super.setValue(this.model.getValue());
                this.updateText();
            }
        }

        @Override
        public void refresh() {
            Double current = (Double)this.getValue();
            this.model.setValue(current.doubleValue());
        }
    }

    protected class FloatProperty
    extends AbstractProperty<Float> {
        private Label label;
        private Label valueText;
        private Slider slider;
        private RangedValueModel model;
        private float step;
        private VersionedReference<Double> value;
        private String format;

        public FloatProperty(String name, Access<Float> access, float min, float max, float step) {
            super(name, access);
            this.format = "%14.3f";
            this.model = new DefaultRangedValueModel((double)min, (double)max, 0.0);
            this.step = step;
        }

        @Override
        public void initialize(Container container) {
            this.label = new Label(this.getDisplayName() + ":", PropertyPanel.this.getElementId().child("float.label"), PropertyPanel.this.getStyle());
            this.label.setTextHAlignment(HAlignment.Right);
            this.slider = new Slider(this.model, Axis.X, PropertyPanel.this.getElementId().child("float.slider"), PropertyPanel.this.getStyle());
            this.slider.setDelta((double)this.step);
            this.refresh();
            this.valueText = new Label("", PropertyPanel.this.getElementId().child("value.label"), PropertyPanel.this.getStyle());
            this.updateText();
            this.value = this.slider.getModel().createReference();
            container.addChild((Node)this.label, new Object[0]);
            container.addChild((Node)this.valueText, new Object[]{1});
            container.addChild((Node)this.slider, new Object[]{2});
        }

        protected void updateText() {
            this.valueText.setText(String.format(this.format, this.model.getValue()));
        }

        @Override
        public void update() {
            if (this.value.update()) {
                super.setValue(Float.valueOf((float)this.model.getValue()));
                this.updateText();
            }
        }

        @Override
        public void refresh() {
            Float current = (Float)this.getValue();
            this.model.setValue((double)current.floatValue());
        }
    }

    protected class BooleanProperty
    extends AbstractProperty<Boolean> {
        private Label label;
        private Checkbox check;
        private VersionedReference<Boolean> value;

        public BooleanProperty(String name, Access<Boolean> access) {
            super(name, access);
        }

        @Override
        public void initialize(Container container) {
            this.label = new Label(this.getDisplayName() + ":", PropertyPanel.this.getElementId().child("boolean.label"), PropertyPanel.this.getStyle());
            this.label.setTextHAlignment(HAlignment.Right);
            this.check = new Checkbox("", PropertyPanel.this.getElementId().child("boolean.checkbox"), PropertyPanel.this.getStyle());
            this.check.setChecked(((Boolean)this.getValue()).booleanValue());
            this.value = this.check.getModel().createReference();
            container.addChild((Node)this.label, new Object[0]);
            container.addChild((Node)this.check, new Object[]{1});
        }

        @Override
        public void update() {
            if (this.value.update()) {
                super.setValue(this.check.isChecked());
            }
        }

        @Override
        public void refresh() {
            this.check.setChecked(((Boolean)this.getValue()).booleanValue());
        }
    }

    protected abstract class AbstractProperty<T>
    implements Property<T> {
        private String name;
        private Access<T> access;

        protected AbstractProperty(String name, Access<T> access) {
            this.name = name;
            this.access = access;
        }

        protected String getDisplayName() {
            return this.name;
        }

        @Override
        public void setValue(T value) {
            this.access.setValue(value);
        }

        @Override
        public T getValue() {
            return this.access.getValue();
        }

        public abstract void initialize(Container var1);

        public abstract void update();

        public abstract void refresh();
    }

    protected class FieldAccess<T>
    implements Access<T> {
        private Object bean;
        private Field fd;

        public FieldAccess(Object bean, String fieldName) {
            this.bean = bean;
            this.fd = PropertyPanel.this.findField(bean, fieldName);
            if (this.fd == null) {
                throw new IllegalArgumentException("Field not found:" + fieldName + " on:" + bean);
            }
        }

        @Override
        public void setValue(T value) {
            PropertyPanel.this.setFieldValue(this.fd, this.bean, value);
        }

        @Override
        public T getValue() {
            return PropertyPanel.this.getFieldValue(this.fd, this.bean);
        }

        @Override
        public Class getType() {
            return this.fd.getType();
        }
    }

    protected class PropertyAccess<T>
    implements Access<T> {
        private Object bean;
        private PropertyDescriptor pd;

        public PropertyAccess(Object bean, String propertyName) {
            this.bean = bean;
            this.pd = PropertyPanel.this.findProperty(bean, propertyName);
            if (this.pd == null) {
                throw new IllegalArgumentException("Property not found:" + propertyName + " on:" + bean);
            }
        }

        @Override
        public void setValue(T value) {
            PropertyPanel.this.setPropertyValue(this.pd, this.bean, value);
        }

        @Override
        public T getValue() {
            return PropertyPanel.this.getPropertyValue(this.pd, this.bean);
        }

        @Override
        public Class getType() {
            return this.pd.getPropertyType();
        }
    }

    protected static interface Access<T> {
        public void setValue(T var1);

        public T getValue();

        public Class getType();
    }

    public static interface Property<T> {
        public void setValue(T var1);

        public T getValue();
    }

    protected class EnabledCheckboxModel
    extends DefaultCheckboxModel {
        protected EnabledCheckboxModel() {
        }

        public void setChecked(boolean checked) {
            if (this.isChecked() == checked) {
                return;
            }
            super.setChecked(checked);
            PropertyPanel.this.resetEnabled();
        }
    }
}

